<?php
use App\Models\User;
use App\Models\Vendor;
use App\Models\Category;
use App\Models\Subcategory;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Storage;

class Helpers {

    /*
     * function for check price response
     */
    public static function commonPriceFormate($price = null)
    {
        if ($price == '' || $price == null) {
            return '--';
        } else {
            return '' .$price;
        }
    }
    
    /*
     * function for check null response
     */
    public static function checkNull($val = null)
    {
        if ($val == '' || $val == null) {
            return '--';
        } else {
            return $val;
        }
    }


    /*
     * function for common date format
     */
    public static function commonDateFormate($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date('d-m-Y', strtotime($value));
        } else {
            return 'NA';
        }
    }


    /**
     * Create slug 
    **/
    public static function createSlug($title,$in='category',$whr=0,$alphaNum = false){
        if($alphaNum){
            $slug = Str::slug($title, '-');
        }else{
            $slug = Str::slug($title, '-');
        }
        if($in == 'subcategory'){           
            $slugExist = Subcategory::where(DB::raw('LOWER(slug)'),strtolower($slug))->where('id','!=',$whr)->get();
        }else if($in == 'category'){
            $slugExist = Category::where(DB::raw('LOWER(slug)'),strtolower($slug))->where('id','!=',$whr)->get();
        }else if($in == 'cms'){
            $slugExist = CmsContent::where(DB::raw('LOWER(page_title)'),strtolower($slug))->where('id','!=',$whr)->get();
        }
        if(count($slugExist)){
            $slug = Str::slug($title.'-'.Str::random(5).'-'.Str::random(5), '-');
            return $slug;
        }else{
            return $slug;
        }
    }


    /**
     * Upload file
    **/
    // public static function uploadFiles($file, $folderName)
    // {
    //     try {
    //         // Get the uploaded file
    //         $image = $file;

    //         // Generate a unique name for the file
    //         $imageName = time().'.'.$image->extension();

    //         // Move the file to the public folder
    //         $image->move(public_path('uploads/'.$folderName), $imageName);

    //         // Return the path to the uploaded image
    //         $imagePath = 'uploads/'.$folderName.'/'.$imageName;

    //         return [
    //             'status' => true,
    //             'message' => config('constant.common.messages.success_image'),
    //             'file_name' => $imageName, // Fix this line
    //         ];
    //     } catch (\Exception $e) {
    //         return [
    //             'status' => false,
    //             'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile(),
    //         ];
    //     }
    // }
      public static function uploadFiles($file, $folderName)
        {
            try {
                // Validate that the file is not null and is valid
                  if ($file instanceof \Illuminate\Http\UploadedFile && $file->isValid()) {
                    // Generate a unique name for the file
                    $imageName = time().'.'.$file->extension();
        
                    // Move the file to the public folder
                    $file->move(public_path('uploads/'.$folderName), $imageName);
        
                    // Return the path to the uploaded image
                    $imagePath = 'uploads/'.$folderName.'/'.$imageName;
        
                    return [
                        'status' => true,
                        'message' => config('constant.common.messages.success_image'),
                        'file_name' => $imageName, // Fix this line
                    ];
                } else {
                    return [
                        'status' => false,
                        'message' => 'Invalid file or no file uploaded.',
                    ];
                }
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile(),
                ];
            }
        }
    
    public static function multipleUploadFiles($file, $folderName)
    {
        try {
            \Log::info('Processing file: ', ['file' => $file->getClientOriginalName()]);
    
            // Generate a unique name for the file
            $imageName = time() . rand(1000, 9999) . '.' . $file->extension();
            $destinationPath = public_path('uploads/' . $folderName);
    
            \Log::info('Saving to: ', ['path' => $destinationPath]);
    
            // Move the file to the public folder
            $file->move($destinationPath, $imageName);
    
            \Log::info('File saved successfully: ', ['file_name' => $imageName]);
    
            // Return the path to the uploaded image
            $imagePath = 'uploads/' . $folderName . '/' . $imageName;
    
            return [
                'status' => true,
                'message' => config('constant.common.messages.success_image'),
                'file_name' => $imageName,
            ];
        } catch (\Exception $e) {
            \Log::error('File upload error: ', ['message' => $e->getMessage(), 'file' => $e->getFile(), 'line' => $e->getLine()]);
            return [
                'status' => false,
                'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile(),
            ];
        }
    }

    // this is for generate api token
    public static function generateToken(){
        mt_srand((double)microtime()*10000);
        $uuid = rand(1,99999).time();
        $salt = substr(sha1(uniqid(mt_rand(), true)), 0, 40);
        return substr(sha1($salt) . $salt,1,85).$uuid;
    }

    /*
     * function for check null response
     */
    public static function descriptionFormate($desc = null)
    {
        // Remove HTML tags
        $res = strip_tags($desc);

        // Check if the result is empty or null
        if ($res == '' || $res == null) {
            return '--';
        } else {
            return $res;
        }
    }
    
    /*
     * function for validate token
     */
    public static function validateAuthToken($token){
            $isValidToken = str_replace('Bearer ', '', $token);
            $tokenExist  = User::where('token',$isValidToken)->first();
            if($tokenExist){
                return $tokenExist;
            }
            return false;
    }
    
    /*
     * function for validate token
     */
    public static function validateVendorAuthToken($token){
            $isValidToken = str_replace('Bearer ', '', $token);
            $tokenExist  = Vendor::where('auth_token',$isValidToken)->first();
            if($tokenExist){
                return $tokenExist;
            }
            return false;
    }
    
    /*
     * function for Feature Data
    */
    public static function featureData($data){
        $featureIds = explode(',', $data);
        $features = DB::table('features')
            ->whereIn('id', $featureIds)
            ->get();
        $output = ''; // Initialize an empty string to hold the HTML output
        if(!empty($features)){
            foreach($features as $key => $feature){
                $output .= ($key + 1) . '. ' . $feature->name . ($key < count($features) - 1 ? '<br>' : ''); // Concatenate HTML string
            }
        }
        return $output; // Return the HTML string
    }
    
    /*
     * function for Guest Data
    */
    public static function guestData($adults, $children){
        $output = $adults . ' Adult';
        if($adults > 1){
            $output .= 's';
        }
        if($children > 0){
            $output .= '<br>' . $children . ' Child';
            if($children > 1){
                $output .= 'ren';
            }
        }
        return $output;
    }
    
    /*
     * Function for generating Fifty Count Data for both add and edit
    */
    public static function fiftyCountData($selected = null) {
        $output = '';
        for ($i = 1; $i <= 50; $i++) {
            $isSelected = ($selected !== null && $selected == $i) ? ' selected' : '';
            $output .= '<option value="' . $i . '"' . $isSelected . '>' . $i . '</option>';
        }
        return $output;
    }
    
    /*
     * Function for multiple ids
    */
    public static function isSelected($id, $selectedIds) {
        $selectedIdsArray = explode(',', $selectedIds);
        return in_array($id, $selectedIdsArray) ? 'selected' : '';
    }
    
    // this is for get Status type
    public static function getStatusType()
    {
        return [
            '1' => __('lang.admin_active_label'),
            '0' => __('lang.admin_deactive_label'),
        ];
    }
    
    // this is for get type
    public static function getType()
    {
        return [
            'Day' => __('lang.admin_day_label'),
            'Night' => __('lang.admin_night_label'),
            'Day-Night' => __('lang.admin_day_night_label'),
        ];
    }
    
    // this is for get type
    public static function getRecommendedType()
    {
        return [
            'Yes' => __('lang.admin_yes_label'),
            'No' => __('lang.admin_no_label'),
        ];
    }
    
    // this is for get type
    public static function allowedType()
    {
        return [
            'Allowed' => __('lang.admin_allowed_label'),
            'Not-Allowed' => __('lang.admin_not_allowed_label'),
        ];
    }
    
    // this is for get discount type
    public static function getDiscountType()
    {
        return [
            'amount' => __('lang.admin_amount_label'),
            'percent' => __('lang.admin_percent_label'),
        ];
    }
    
    // this is for get coupon type
    public static function getCouponTypes()
    {
        return [
            'default' => 'Default'
        ];
    }
    
    /**
     * Format booking data.
     *
     * @param mixed $data The booking data, can be a single object or a collection.
     * @param bool $multiData Whether to format multiple data entries.
     * @param bool $trans Whether to include translations (not used here but added for future flexibility).
     * @param string|null $locale The locale for translations (not used here but added for future flexibility).
     * @return mixed Formatted booking data.
     */
    public static function formatBookingData($data, $multiData = false, $trans = false, $locale = null)
    {
        if ($multiData) {
            return $data->map(function ($booking) {
                return self::formatSingleBooking($booking);
            });
        } else {
            return self::formatSingleBooking($data);
        }
    }

    /**
     * Format a single booking entry.
     *
     * @param object $booking The booking object.
     * @return array Formatted booking data.
     */
    private static function formatSingleBooking($booking)
    {
        return [
            'id' => $booking->id,
            'user_id' => $booking->user_id,
            'hotel_data' => [
                'hotel_id' => $booking->hotel_id,
                'hotel_name' => $booking->hotel ? $booking->hotel->name : null,
                'hotel_image' => $booking->hotel ? url('uploads/hotel/front_image/' . $booking->hotel->front_image) : null,
            ],
            'room' => $booking->room,
            'guest' => $booking->guest,
            'start_date' => $booking->start_date,
            'end_date' => $booking->end_date,
            'price' => $booking->price,
            'status' => $booking->status,
            'booking_guests' => $booking->booking_guests,
            'created_at' => $booking->created_at,
            'updated_at' => $booking->updated_at,
        ];
    }
    
    
    /**
     * Format hotel data.
     *
     * @param object $hotel The hotel object.
     * @return array Formatted hotel data.
     */
    public static function formatHotelData($hotel)
    {
        // Format hotel images
        $hotelImages = $hotel->hotelImages()->get()->map(function ($image) {
            return [
                'id' => $image->id,
                'hotel_id' => $image->hotel_id,
                'images' => url('uploads/hotel/images/' . $image->images),
            ];
        });

        // Format hotel amenities
        $hotelAmenities = $hotel->hotelAminities()->with('aminity')->get()->map(function ($amenity) {
            return [
                'id' => $amenity->aminities_id,
                // 'aminities_id' => $amenity->aminities_id,
                'hotel_id' => $amenity->hotel_id,
                'aminities_name' => $amenity->aminity ? $amenity->aminity->name : null,
                'aminityimage' => $amenity->aminity ? url('uploads/aminity/' . $amenity->aminity->image) : null,
            ];
        });

        // Format hotel additional info
        $additionalInfos = $hotel->additionalInfos()->get()->map(function ($info) {
            return [
                'id' => $info->id,
                'hotel_id' => $info->hotel_id,
                'title' => $info->title,
            ];
        });

        // Format hotel specifications
        $specifications = $hotel->specification()->get()->map(function ($spec) {
            return [
                'id' => $spec->id,
                'hotel_id' => $spec->hotel_id,
                'title' => $spec->title,
            ];
        });
        
         // Calculate and add average rating
    $averageRating = $hotel->ratings->avg('rating') ?? null;
      unset($hotel->ratings);

        // Format hotel cancellation policies
        $cancellationPolicies = $hotel->cancellationPolicies()->get()->map(function ($policy) {
            return [
                'id' => $policy->id,
                'hotel_id' => $policy->hotel_id,
                'title' => $policy->title,
            ];
        });

        // Format hotel features
        // $hotelFeatures = $hotel->hotelFeatures()->with('feature')->get()->map(function ($feature) {
        //     return [
        //         'id' => $feature->id,
        //         'hotel_id' => $feature->hotel_id,
        //         'feature_name' => $feature->feature->name,
        //     ];
        // });
        
        // Format hotel Rules
        $hotelRules = $hotel->hotelRules()->with('rules')->get()->map(function ($rules) {
            return [
                // 'id' => $rules->id,
                 'id' => $rules->rules_id,
                'hotel_id' => $rules->hotel_id,
                'rules_name' => $rules->rules ? $rules->rules->name : null,
            ];
        });
        
        // Format hotel Off days
        $hotelOffDays = $hotel->offdays()->get()->map(function ($off_Days) {
            return [
                'id' => $off_Days->id,
                'hotel_id' => $off_Days->hotel_id,
                'off_days' => $off_Days->off_days,
            ];
        });
        
         $userIdentityUrl = url($hotel->user_identity);
         
    $agreementFileUrl = url($hotel->agreement_file);

        // Return formatted hotel data
        return [
            'details_data' => $hotel,
            'average_rating' => $averageRating,
            'hotelImages' => $hotelImages,
            'hotelAminities' => $hotelAmenities,
            'additionalInfos' => $additionalInfos,
            'specifications' => $specifications,
            'cancellationPolicies' => $cancellationPolicies,
            // 'hotelFeatures' => $hotelFeatures,
            'hotelRules' => $hotelRules,
            'hotelOffDays' => $hotelOffDays,
            'user_identity' => $userIdentityUrl,  // Add user identity image URL
            'agreement_file' => $agreementFileUrl,
        ];
    }
    
    /**
     * Format All Hotel data.
     *
     * @param \Illuminate\Database\Eloquent\Collection $hotels The hotel collection.
     * @return array Formatted hotel data.
     */
    public static function formatAllHotelData($hotels)
    {
        return $hotels->map(function ($hotel) {
           
            // Avoid re-fetching related data multiple times
            $hotel->load(['hotelImages', 'hotelAminities.aminity', 'additionalInfos', 'specification', 'cancellationPolicies']);
            
            // Format hotel images
            $hotelImages = $hotel->hotelImages->map(function ($image) {
                return [
                    'id' => $image->id,
                    'hotel_id' => $image->hotel_id,
                    'images' => url('uploads/hotel/images/' . $image->images),
                ];
            });
    
            // Format hotel amenities
            $hotelAmenities = $hotel->hotelAminities->map(function ($amenity) {
                return [
                    'id' => $amenity->id,
                    'hotel_id' => $amenity->hotel_id,
                    'aminities_name' => $amenity->aminity->name ?? null,
                    'aminityimage' => url('uploads/aminity/' . $amenity->aminity->image),
                ];
            });
    
            // Format hotel additional info
            $additionalInfos = $hotel->additionalInfos->map(function ($info) {
                return [
                    'id' => $info->id,
                    'hotel_id' => $info->hotel_id,
                    'title' => $info->title,
                ];
            });
    
            // Format hotel specifications
            $specifications = $hotel->specification->map(function ($spec) {
                return [
                    'id' => $spec->id,
                    'hotel_id' => $spec->hotel_id,
                    'title' => $spec->title,
                ];
            });
    
            // Format hotel cancellation policies
            $cancellationPolicies = $hotel->cancellationPolicies->map(function ($policy) {
                return [
                    'id' => $policy->id,
                    'hotel_id' => $policy->hotel_id,
                    'title' => $policy->title,
                ];
            });
    
            // Format hotel features
            // $hotelFeatures = $hotel->hotelFeatures->map(function ($feature) {
            //     return [
            //         'id' => $feature->id,
            //         'hotel_id' => $feature->hotel_id,
            //         'feature_name' => $feature->feature->name,
            //     ];
            // });
            
            // Format hotel Rules
            $hotelRules = $hotel->hotelRules->map(function ($rules) {
                return [
                    'id' => $rules->id,
                    'hotel_id' => $rules->hotel_id,
                     'rules_name' => $rules->rules ? $rules->rules->name : null,
                ];
            });
            
            // Format hotel cancellation policies
            $hotelOffDays = $hotel->offdays->map(function ($off_Days) {
                return [
                    'id' => $off_Days->id,
                    'hotel_id' => $off_Days->hotel_id,
                    'off_days' => $off_Days->off_days,
                ];
            });
    
    
     $hotelBookings = $hotel->bookings->map(function ($booking) { 
    
            return [
                'id' => $booking->id,
                'start_date ' => $booking->start_date,
                'end_date ' => $booking->end_date,
                'created_at' => $booking->created_at->format('Y-m-d H:i:s'), // format the creation date as needed
            ];
        });
        
         $blockDates = $hotel->block_date ? json_decode($hotel->block_date, true) : [];
          
            // Return formatted hotel data without duplicates
            return [
                    'id' => $hotel->id,
                    'vendor_id' => $hotel->vendor_id,
                    'destination_id' => $hotel->destination_id,
                    // 'category_id' => $hotel->category_id,
                    'name' => $hotel->name,
                    'address' => $hotel->address,
                    'latitude' => $hotel->latitude,
                    'longitude' => $hotel->longitude,
                    'street' => $hotel->street,
                    'area' => $hotel->area,
                    'city' => $hotel->city,
                    'pincode' => $hotel->pincode,
                    'state' => $hotel->state,
                    'max_guest' => $hotel->max_guest,
                    'rooms' => $hotel->rooms,
                    'bedrooms' => $hotel->bedrooms,
                    'beds' => $hotel->beds,
                    'bathrooms' => $hotel->bathrooms,
                    'smoking' => $hotel->smoking,
                    'pets' => $hotel->pets,
                    'parties_events' => $hotel->parties_events,
                    'check_in' => $hotel->check_in,
                    'check_out' => $hotel->check_out,
                    'minimum_price' => $hotel->minimum_price,
                    'maximum_price' => $hotel->maximum_price,
                    'profile_name' => $hotel->profile_name,
                    'phone' => $hotel->phone,
                    'profile_pic' =>url('uploads/hotel/profile_pic/' . $hotel->profile_pic),
                    'original_price' => $hotel->price,
                    'type' => $hotel->type,
                    'service_charge' => $hotel->service_charge,
                    'tax_fees' => $hotel->tax_fees,
                    'is_recommended' => $hotel->is_recommended,
                    'created_at' => $hotel->created_at,
                    'hotelImages' => $hotelImages,
                    'hotelAminities' => $hotelAmenities,
                    'additionalInfos' => $additionalInfos,
                    'specifications' => $specifications,
                    'cancellationPolicies' => $cancellationPolicies,
                    
                    // 'hotelFeatures' => $hotelFeatures,
                    'hotelRules' => $hotelRules,
                    'hotelOffDays' => $hotelOffDays,
                    'hotelBookings' => $hotelBookings,
                    'user_identity' => url($hotel->user_identity),
                    'agreement_file' =>url($hotel->agreement_file),
                     'block_dates' => $blockDates,
                ];
        })->toArray();
        
    }

    
    /**
     * Format booking data.
     *
     * @param mixed $data The booking data, can be a single object or a collection.
     * @param bool $multiData Whether to format multiple data entries.
     * @param bool $trans Whether to include translations (not used here but added for future flexibility).
     * @param string|null $locale The locale for translations (not used here but added for future flexibility).
     * @return mixed Formatted booking data.
     */
    public static function formatBookingDetails($data, $multiData = false, $trans = false, $locale = null)
    {
        if ($multiData) {
            return $data->map(function ($booking) {
                return self::formatDataBookingDetails($booking);
            });
        } else {
            return self::formatDataBookingDetails($data);
        }
    }
    
    /**
     * Format a single booking entry.
     *
     * @param object $booking The booking object.
     * @return array Formatted booking data.
     */
    /**
     * Format booking details.
     *
     * @param object $booking The booking object.
     * @return array Formatted booking details.
     */
    public static function formatDataBookingDetails($booking)
    {
        return [
            'id' => $booking->id,
            'user_id' => $booking->user_id,
            'room' => $booking->room,
            'guest' => $booking->guest,
            'start_date' => $booking->start_date,
            'end_date' => $booking->end_date,
            'price' => $booking->price,
            'status' => $booking->status,
            'booking_guests' => $booking->booking_guests->map(function ($guest) {
                return [
                    'id' => $guest->id,
                    'booking_id' => $guest->booking_id,
                    'full_name' => $guest->full_name ?? null,
                    'gender' => $guest->gender ?? null,
                    'phone' => $guest->phone ?? null,
                    'email' => $guest->email ?? null,
                    'id_card_type' => $guest->id_card_type ?? null,
                    'card_number' => $guest->card_number ?? null,
                ];
            }),
            'hotel_data' => self::formatHotelDataForBooking($booking->hotel),
            'created_at' => $booking->created_at,
            'updated_at' => $booking->updated_at,
        ];
    }
    
    /**
     * Format hotel data.
     *
     * @param object $hotel The hotel object.
     * @return array Formatted hotel data.
     */
    public static function formatHotelDataForBooking($hotel)
    {
        if (!$hotel) {
            return [];
        }

        // Format hotel images
        $hotelImages = $hotel->hotelImages()->get()->map(function ($image) {
            return [
                'id' => $image->id,
                'hotel_id' => $image->hotel_id,
                'images' => $image->images ? url('uploads/hotel/images/' . $image->images) : null,
            ];
        });

        // Format hotel amenities
        $hotelAmenities = $hotel->hotelAminities()->with('aminity')->get()->map(function ($amenity) {
            return [
                'id' => $amenity->id,
                'hotel_id' => $amenity->hotel_id,
                'aminities_name' => $amenity->aminity->name ?? null,
                'aminityimage' => $amenity->aminity->image ? url('uploads/aminity/' . $amenity->aminity->image) : null,
            ];
        });

        // Format hotel additional info
        $additionalInfos = $hotel->additionalInfos()->get()->map(function ($info) {
            return [
                'id' => $info->id,
                'hotel_id' => $info->hotel_id,
                'title' => $info->title ?? null,
            ];
        });

        // Format hotel specifications
        $specifications = $hotel->specification()->get()->map(function ($spec) {
            return [
                'id' => $spec->id,
                'hotel_id' => $spec->hotel_id,
                'title' => $spec->title ?? null,
            ];
        });

        // Format hotel cancellation policies
        $cancellationPolicies = $hotel->cancellationPolicies()->get()->map(function ($policy) {
            return [
                'id' => $policy->id,
                'hotel_id' => $policy->hotel_id,
                'title' => $policy->title ?? null,
            ];
        });

        // Format hotel features
        // $hotelFeatures = $hotel->hotelFeatures()->with('feature')->get()->map(function ($feature) {
        //     return [
        //         'id' => $feature->id,
        //         'hotel_id' => $feature->hotel_id,
        //         'feature_name' => $feature->feature->name ?? null,
        //     ];
        // });

        // Return formatted hotel data
        return [
            'details_data' => [
                'id' => $hotel->id,
                'name' => $hotel->name ?? null,
                // 'category' => $hotel->category->name ?? null,
                'destination' => $hotel->destination->name ?? null,
                'hotel_image' => $hotel ? url('uploads/hotel/front_image/' . $hotel->front_image) : null,
                'guest' => $hotel->guest ?? null,
                'room' => $hotel->room ?? null,
                'address' => $hotel->address ?? null,
                'address' => $hotel->address ?? null,
                'hotel_contact_number' => $hotel->phone ?? null,
            ],
            'hotelImages' => $hotelImages,
            'hotelAminities' => $hotelAmenities,
            'additionalInfos' => $additionalInfos,
            'specifications' => $specifications,
            'cancellationPolicies' => $cancellationPolicies,
            // 'hotelFeatures' => $hotelFeatures,
        ];
    }


}

?>