<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Auth;
use DB;
use Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;
use App\Models\User;
use App\Models\Booking;
use App\Models\CancelBooking;
use App\Models\Coupon;
use App\Models\Hotel;
use App\Models\BookingGuest;
use App\Models\Package;
use App\Models\{Reason,Notification};


class BookingAPIController extends Controller
{
    private $language;
    public function __construct()
    {
        // No need to call parent::__construct() here
        $this->language = request()->header('language-code') && request()->header('language-code') != '' ? request()->header('language-code') : 'en';
    }
    
    /**
     *  Do Save Booking
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function doSaveBooking(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'hotel_id' => 'required|exists:hotels,id',
            'room_count' => 'required|integer|min:1',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
            'guest_full_name' => 'required|array',
            'guest_gender' => 'required|array',
            'guest_phone' => 'required|array',
            'guest_email' => 'required|array',
            'guest_id_card_type' => 'required|array',
            // 'guest_card_number' => 'required|array',
            'adharcard_image' => 'required',
            'adharcard_image.*' => 'required|file|image|mimes:jpeg,png,jpg',
        ]);
    
        if ($validator->fails()) {
            return $this->sendError(__('lang.message_required_message'), $validator->errors());
        }
    
        try {
            // Start Transaction
            DB::beginTransaction();
    
            // Fetch Hotel Pricing Information
            $hotel = Hotel::find($request->hotel_id);
            if (!$hotel) {
                throw new \Exception('Hotel not found.');
            }
            
             $exists = DB::table('bookings')
            ->where('hotel_id', $request->hotel_id)
            ->where(function ($query) use ($request) {
                $startDate = $request->start_date;
                $endDate = $request->end_date;
        
                $query->whereBetween('start_date', [$startDate, $endDate])
                      ->orWhereBetween('end_date', [$startDate, $endDate]);
            })->exists();
        
        
            if ($exists) {
                throw new \Exception('The selected dates are already booked in Match.');
            }else{ 
          
    
            // Pricing from hotel
            // $pricePerGuest = $hotel->price;
            // $serviceChargePerGuest = $hotel->service_charge;
            // $taxFeesPerGuest = $hotel->tax_fees;
    
            // Guest Information Arrays
            $guestFullNames = $request->input('guest_full_name');
            $guestGenders = $request->input('guest_gender');
            $guestPhones = $request->input('guest_phone');
            $guestEmails = $request->input('guest_email');
            $guestIdCardTypes = $request->input('guest_id_card_type');
            // $guestCardNumbers = $request->input('guest_card_number');
             $guestCardImages = $request->file('adharcard_image');
            
           
    
            // Number of Guests
            $numberOfGuests = count($guestFullNames);
    
            // // Check if all fields have the same number of entries
            if (
                count($guestGenders) !== $numberOfGuests ||
                count($guestPhones) !== $numberOfGuests ||
                count($guestEmails) !== $numberOfGuests ||
                count($guestIdCardTypes) !== $numberOfGuests 
                // ||
                // count($guestCardNumbers) !== $numberOfGuests
                //   count($guestCardImages) !== $numberOfGuests
            ) {
                throw new \Exception('Guest information fields count mismatch.');
            }
    

    
            // Calculate Total Price
            // $totalPrice = $pricePerGuest * $numberOfGuests;
            // $totalServiceCharge = $serviceChargePerGuest * $numberOfGuests;
            // $totalTaxFees = $taxFeesPerGuest * $numberOfGuests;
    
            // Create Booking
            $booking = Booking::create([
                'user_id' => $request->user->id,
                'hotel_id' => $request->hotel_id,
                'room' => $request->room_count,
                'guest' => $numberOfGuests,
                'start_date' => $request->start_date,
                'end_date' => $request->end_date,
                // 'price' => $totalPrice + $totalServiceCharge + $totalTaxFees,
                'price' => $request->totalPrice,
                'status' => 1,
            ]);
    
            // Create Booking Guests
            foreach ($guestFullNames as $key => $fullName) {
                $gender = $guestGenders[$key];
                $phone = $guestPhones[$key];
                $email = $guestEmails[$key];
                $idCardType = $guestIdCardTypes[$key];
                // Check if $guestCardImages is an array (multiple files)
                if (is_array($guestCardImages)) {
                    $file = $guestCardImages[$key];
                } else {
                    $file = $guestCardImages; // Single file
                }
            
                // Save the file (Adharcard image)
                $cardFileName = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('uploads/user/adharcard_image/'), $cardFileName);
            
            
                BookingGuest::create([
                    'booking_id' => $booking->id,
                    'full_name' => trim($fullName),
                    'gender' => trim($gender),
                    'phone' => trim($phone),
                    'email' => trim($email),
                    'id_card_type' => trim($idCardType),
                    // 'card_number' => trim($cardNumber),
                     'card_file' => 'uploads/user/adharcard_image/'.$cardFileName,
                ]);
            }
            
             Notification::create([
                'booking_id' => $booking->id,
                'vendor_id' => $hotel->vendor_id,
            ]);

    
            // Commit Transaction
            DB::commit();
    
            // Retrieve Booking with Guests
            $booking = Booking::with('booking_guests')->find($booking->id);
            return $this->sendResponse($booking, __('lang.message_data_retrived_successfully'));
            }
        } catch (\Exception $ex) {
            DB::rollBack();
            return $this->sendError($ex->getMessage());
        }
    }


//   public function doSaveBooking(Request $request)
//     { $validator = Validator::make($request->all(), [
//             'hotel_id' => 'required|exists:hotels,id',
//             'room_count' => 'required|integer|min:1',
//             'start_date' => 'required|date',
//             'end_date' => 'required|date|after_or_equal:start_date',
//             'guest_full_name' => 'required|array',
//             'guest_gender' => 'required|array',
//             'guest_phone' => 'required|array',
//             'guest_email' => 'required|array',
//             'guest_id_card_type' => 'required|array',
//             'guest_card_number' => 'required|array',
//         ]);
    
//         if ($validator->fails()) {
//             return $this->sendError(__('lang.message_required_message'), $validator->errors());
//         }
    
//         try {
//             // Start Transaction
//             DB::beginTransaction();
    
//             // Fetch Hotel Pricing Information
//             $hotel = Hotel::find($request->hotel_id);
//             if (!$hotel) {
//                 throw new \Exception('Hotel not found.');
//             }
            
//             
    
//             // Pricing from hotel
//             $pricePerGuest = $hotel->price;
//             $serviceChargePerGuest = $hotel->service_charge;
//             $taxFeesPerGuest = $hotel->tax_fees;
    
//             // Guest Information Arrays
//             $guestFullNames = $request->input('guest_full_name');
//             $guestGenders = $request->input('guest_gender');
//             $guestPhones = $request->input('guest_phone');
//             $guestEmails = $request->input('guest_email');
//             $guestIdCardTypes = $request->input('guest_id_card_type');
//             $guestCardNumbers = $request->input('guest_card_number');
    
//             // Number of Guests
//             $numberOfGuests = count($guestFullNames);
    
//             // Check if all fields have the same number of entries
//             if (
//                 count($guestGenders) !== $numberOfGuests ||
//                 count($guestPhones) !== $numberOfGuests ||
//                 count($guestEmails) !== $numberOfGuests ||
//                 count($guestIdCardTypes) !== $numberOfGuests ||
//                 count($guestCardNumbers) !== $numberOfGuests
//             ) {
//                 throw new \Exception('Guest information fields count mismatch.');
//             }
    
//             // Calculate Total Price
//             $totalPrice = $pricePerGuest * $numberOfGuests;
//             $totalServiceCharge = $serviceChargePerGuest * $numberOfGuests;
//             $totalTaxFees = $taxFeesPerGuest * $numberOfGuests;
    
//             // Create Booking
//             $booking = Booking::create([
//                 'user_id' => $request->user->id,
//                 'hotel_id' => $request->hotel_id,
//                 'room' => $request->room_count,
//                 'guest' => $numberOfGuests,
//                 'start_date' => $request->start_date,
//                 'end_date' => $request->end_date,
//                 'price' => $totalPrice + $totalServiceCharge + $totalTaxFees,
//                 'status' => 1,
//             ]);
    
//             // Create Booking Guests
//             foreach ($guestFullNames as $key => $fullName) {
//                 $gender = $guestGenders[$key];
//                 $phone = $guestPhones[$key];
//                 $email = $guestEmails[$key];
//                 $idCardType = $guestIdCardTypes[$key];
//                 $cardNumber = $guestCardNumbers[$key];
    
//                 BookingGuest::create([
//                     'booking_id' => $booking->id,
//                     'full_name' => trim($fullName),
//                     'gender' => trim($gender),
//                     'phone' => trim($phone),
//                     'email' => trim($email),
//                     'id_card_type' => trim($idCardType),
//                     'card_number' => trim($cardNumber),
//                 ]);
//             }
    
//             // Commit Transaction
//             DB::commit();
    
//             // Retrieve Booking with Guests
//             $booking = Booking::with('booking_guests')->find($booking->id);
//             return $this->sendResponse($booking, __('lang.message_data_retrived_successfully'));
// 
//         } catch (\Exception $ex) {
//             DB::rollBack();
//             return $this->sendError($ex->getMessage());
//         }
//     }

    
    
    /**
     * Fetch list here
    **/
    public  function getCouponList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Coupon::where('status',1)->get();
            
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public function getTripsHotel(Request $request)
    {
        
        try {
            $validator = Validator::make($request->all(), [
                'type' => 'required|in:Upcoming,Complete',
            ]);
    
            if ($validator->fails()) {
                return $this->sendError(__('lang.message_required_message'), $validator->errors());
            }
    
            // Get the pagination number
            $pagination_no = config('constant.api_pagination');
            if (isset($request->per_page) && !empty($request->per_page)) {
                $pagination_no = $request->per_page;
            }
    
            // Get the current user ID
            $user_id = $request->user->id;
    
            $current_date = now()->toDateString();
            $type = $request->type;
    
            // Base query for fetching bookings
            $query = Booking::where('user_id', $user_id);
    
           if ($type == 'Upcoming') {
                    $query->whereHas('payments', function($q) {
                        $q->where('payment_status', 1)  // Check if payment status is completed (1)
                          ->withTrashed();  // Include payments even if they are soft deleted
                    });
                }

            
            elseif ($type == 'Complete') {
                $query->where('end_date', '<', $current_date);
            }
    
            // Fetch bookings with related hotels and guests
            $bookings = $query->with(['hotel', 'booking_guests','cancelBookings'])
                ->get();
                
                // echo"<pre>";print_r($bookings->toArray());die;
                
            // Check if there are no bookings
            if ($bookings->isEmpty()) {
                $message = ($type == 'Upcoming') ? __('lang.message_no_upcoming_bookings') : __('lang.message_no_complete_bookings');
                return $this->sendResponse([], $message);
            }
    
            // Format the response using the helper function
            $formattedBookings = \Helpers::formatBookingData($bookings, true, false, app()->getLocale());
    
            // Send response
            return $this->sendResponse($formattedBookings, __('lang.message_data_retrived_successfully'));
    
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
    
    
     public function tripsAllListData(Request $request)
    {
        
        try {
         
    
            // Get the current user ID
            $user_id = $request->user->id;
    
          
            // Base query for fetching bookings
            $query = Booking::where('user_id', $user_id);
    
    
            // Fetch bookings with related hotels and guests
            $bookings = $query->with(['hotel', 'booking_guests','cancelBookings'])
                ->get();
            // Format the response using the helper function
            $formattedBookings = \Helpers::formatBookingData($bookings, true, false, app()->getLocale());
    
            // Send response
            return $this->sendResponse($formattedBookings, __('lang.message_data_retrived_successfully'));
    
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public function getBookingAllData(Request $request)
    {
        try {
            // Get the pagination number
            $pagination_no = config('constant.api_pagination');
            if (isset($request->per_page) && !empty($request->per_page)) {
                $pagination_no = $request->per_page;
            }
    
            // Get the current user ID
            $user_id = $request->user->id;
    
            $query = Booking::where('user_id', $user_id);
            $bookings = $query->with(['hotel', 'booking_guests'])
                ->get();
            // Format the response using the helper function
            $formattedBookings = \Helpers::formatBookingDetails($bookings, true, false, app()->getLocale());
    
            // Send response
            return $this->sendResponse($formattedBookings, __('lang.message_data_retrived_successfully'));
    
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public function getBookingDetailsData(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'bookingId' => 'required|exists:bookings,id',
            ]);
    
            if ($validator->fails()) {
                return $this->sendError(__('lang.message_required_message'), $validator->errors());
            }
            // Get the pagination number
            $pagination_no = config('constant.api_pagination');
            if (isset($request->per_page) && !empty($request->per_page)) {
                $pagination_no = $request->per_page;
            }
            
            // Get the current user ID
            $booking_id = $request->bookingId;
    
            $query = Booking::where('id', $booking_id);
            $bookings = $query->with(['hotel', 'booking_guests'])
                ->get();
                
            // Format the response using the helper function
            $formattedBookings = \Helpers::formatBookingDetails($bookings, true, false, app()->getLocale());
    
            // Send response
            return $this->sendResponse($formattedBookings, __('lang.message_data_retrived_successfully'));
    
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
     public function reasonList(Request $request)
    {
        // Fetch all reasons for cancellation
        $reasons = Reason::select('id', 'name')->get(); 

        // Return the data as a JSON response
        return response()->json($reasons);
    }
    
    
    /**
     * Do Delete Booking And Save Cancel Booking
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function doCancelBooking(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'booking_id' => 'required|exists:bookings,id',
            'reason' => 'required|string',
        ]);
    
        if ($validator->fails()) {
            return $this->sendError(__('lang.message_required_message'), $validator->errors());
        }
    
        try {
            // Start Transaction
            DB::beginTransaction();
    
            // Find and delete the booking
            $booking = Booking::find($request->booking_id);
            if (!$booking) {
                throw new \Exception('Booking not found.');
            }
            // Create a cancel booking record
            $cancelBooking = CancelBooking::create([
                'user_id' => $request->user->id,
                'booking_id' => $request->booking_id,
                'hotel_id' => $booking->hotel_id,
                'reason' => $request->reason,
                'details' => $request->details,
            ]);
            $booking->delete();
    
            // Commit Transaction
            DB::commit();
    
            // Retrieve CancelBooking with relationships
            $cancelBooking = CancelBooking::with(['user:id,name', 'hotel:id,name'])->find($cancelBooking->id);
            
            return $this->sendResponse($cancelBooking, __('lang.message_booking_cancel_successfully'));
        } catch (\Exception $ex) {
            DB::rollBack();
            return $this->sendError($ex->getMessage());
        }
    }
    
    
}
