<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\RecentlyViewedHotel;
use Illuminate\Support\Str;
use Auth;
use Validator;
use App\Models\User;
use Illuminate\Support\Facades\Log;
use App\Models\Hotel;
use App\Models\Additional_Info;
use App\Models\Destination;
use App\Models\Feature;
use App\Models\Rules;
use App\Models\Cancellation_Policy;
use App\Models\Specification;
use App\Models\Hotel_Aminities;
use App\Models\{Hotel_Images,State,Videocontent};
use Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;
use DB;
class HotelAPIController extends Controller
{
    private $language;
    public function __construct()
    {
        // No need to call parent::__construct() here
        $this->language = request()->header('language-code') && request()->header('language-code') != '' ? request()->header('language-code') : 'en';
    }

    /**
     * Get List
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getLatestHotel(Request $request)
    {
        try {
            $pagination_no = config('constant.api_pagination');
            if (isset($request->per_page) && !empty($request->per_page)) {
                $pagination_no = $request->per_page;
            }

            // Fetch hotels with related category and destination
            $hotels = Hotel::where('status',1)
                ->with(['destination'])
                ->select('id', 'name', 'price', 'type', 'destination_id', 'front_image')
                ->latest()->take(4)->get(); // Adjust pagination if needed
                // echo"<pre>";print_r($hotels->toArray());die;

            // Process the retrieved data
            foreach ($hotels as $hotel) {
                $hotel->front_image = url('uploads/hotel/front_image/' . $hotel->front_image);
                // Add destination name to the response
                $hotel->destination_name = $hotel->destination ? $hotel->destination->name : null;
            }

            // Send response
            $response = $this->sendResponse($hotels, __('lang.message_data_retrived_successfully'));
            return $response;
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public  function getLocationList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Destination::where('status',1)->select('id','name')->get();
            if(count($resData)){
                foreach($resData as $row){
                    $row->image = url('uploads/destination/'.$row->image) ?? null;
                }
            }
            
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public  function getFeatureList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Feature::where('status',1)->select('id','name')->get();
            
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }
    
    /**
     * Get Full List
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
          public function getHotelList(Request $request)
        {
            try {
                // Set default pagination
                $pagination_no = config('constant.api_pagination', 10);
        
                // Update pagination if per_page is set
                if ($request->has('per_page') && !empty($request->per_page)) {
                    $pagination_no = (int) $request->per_page;
                }
        
                // Start building the query
                $query = Hotel::whereIn('add_type', ['Admin', 'Vendor'])
                    ->with(['destination:id,name', 'aminities:id,name', 'ratings'])
                    ->select('id', 'name', 'price', 'type', 'destination_id', 'front_image');
        
                // Apply destination filter
                if ($request->has('destination_id') && !empty($request->destination_id)) {
                    $query->where('destination_id', $request->destination_id);
                }
        
                // Apply price filter
                if ($request->has('price') && !empty($request->price)) {
                    $priceRange = explode('-', $request->price);
                    if (count($priceRange) == 2) {
                        $query->whereBetween('price', [$priceRange[0], $priceRange[1]]);
                    } else {
                        // Handle single value price filter
                        $query->where('price', $priceRange[0]);
                    }
                }
        
                // Get the results with pagination
                $hotels = $query->latest()->get();
              
        
                // Process each hotel to add required data
                $hotels->transform(function ($hotel) {
                    // Build the front image URL
                    $hotel->front_image = url('uploads/hotel/front_image/' . $hotel->front_image);
                    
                    // Add destination name
                    $hotel->destination_name = $hotel->destination ? $hotel->destination->name : null;
        
                    // Add amenities list
                    $hotel->amenities_list = $hotel->aminities->pluck('name');
        
                    // Calculate and add average rating, casting to float to avoid type errors
                    $hotel->average_rating = $hotel->ratings->avg(function ($rating) {
                        return (float) $rating->rating;
                    }) ?? null;
                    unset($hotel->ratings);
        
                    // Add destination id and name separately
                    if ($hotel->destination) {
                        $hotel->destination = [
                            'id' => $hotel->destination->id,
                            'name' => $hotel->destination->name
                        ];
                    }
        
                    return $hotel;
                });
        
                // Send response
                return $this->sendResponse($hotels, __('lang.message_data_retrived_successfully'));
            } catch (\Exception $ex) {
                // Send error response
                return $this->sendError($ex->getMessage());
            }
        }

    /**
     * Fetch Details here
    **/
    public function hotelDetails(Request $request)
    {
        try {
            
            $hotelData = Hotel::where('status', 1)
                ->with('destination')
                ->where('id', $request->hotelId)
                ->first();
    
            if (!$hotelData) {
                return $this->sendError('Hotel not found');
            }
    
            // Format the response using the helper function
            $formattedHotelData = \Helpers::formatHotelData($hotelData);
    
            // Return the response with the relevant data
            return $this->sendResponse($formattedHotelData, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            // Return error response in case of exception
            return $this->sendError($ex->getMessage());
        }
    }

   public function getState(Request $request)
    {
        try {
            
            $stateData = State::get();
    
            if (!$stateData) {
                 return $this->sendError('State data not found');
            }
    
            // // Format the response using the helper function
            // $formattedHotelData = \Helpers::formatHotelData($hotelData);
    
            // Return the response with the relevant data
            return $this->sendResponse($stateData, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            // Return error response in case of exception
            return $this->sendError($ex->getMessage());
        }
    }
    
    
     public function getVideoContent(Request $request)
{
    try {
        // Retrieve all video content data
        $videoContentData = Videocontent::all(); // Use `all()` instead of `get()`

        // Check if data exists
        if ($videoContentData->isEmpty()) {
            return $this->sendError('No video content data found');
        }

        $video_paths = [];
        foreach ($videoContentData as $videoContent) {
            // Add video path to the array
            $vide = $videoContent->video_path;
            $video_paths[] = url($vide); // Directly access the attribute
        }

        // Return the response with the relevant data
        return $this->sendResponse($video_paths, __('lang.message_data_retrieved_successfully'));
    } catch (\Exception $ex) {
        // Return error response in case of exception
        return $this->sendError($ex->getMessage());
    }
}

    /**
     * Get Recommended List
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getRecommendedList(Request $request)
    {
        try {
            // Set default pagination
            $pagination_no = config('constant.api_pagination', 10);
    
            // Update pagination if per_page is set
            if ($request->has('per_page') && !empty($request->per_page)) {
                $pagination_no = (int) $request->per_page;
            }
    
            // Start building the query
            $query = Hotel::where('status', 1)
                ->where('is_recommended','Yes')
                ->with(['destination:id,name', 'aminities:id,name'])
                ->select('id', 'name', 'price', 'type', 'destination_id', 'front_image');
    
            // Get the results with pagination
            $hotels = $query->latest()->get();
    
            // Process each hotel to add required data
            $hotels->transform(function ($hotel) {
                // Build the front image URL
                $hotel->front_image = url('uploads/hotel/front_image/' . $hotel->front_image);
                
                // Add destination name
                $hotel->destination_name = $hotel->destination ? $hotel->destination->name : null;
                
                // Add amenities list
                $hotel->amenities_list = $hotel->aminities->pluck('name');
                
                // Add destination id and name separately
                if ($hotel->destination) {
                    $hotel->destination = [
                        'id' => $hotel->destination->id,
                        'name' => $hotel->destination->name
                    ];
                }
                
                return $hotel;
            });
    
            // Send response
            return $this->sendResponse($hotels, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            // Send error response
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
     * Get Recommended List
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getExplorePlace(Request $request)
    {
        try {
            // Set default pagination
            $pagination_no = config('constant.api_pagination', 10);
    
            // Update pagination if per_page is set
            if ($request->has('per_page') && !empty($request->per_page)) {
                $pagination_no = (int) $request->per_page;
            }
    
            // Get the destinations ordered by the number of bookings
            $explorePlace = Destination::select('destinations.*')
                ->join('hotels', 'hotels.destination_id', '=', 'destinations.id')
                ->join('bookings', 'bookings.hotel_id', '=', 'hotels.id')
                ->where('destinations.status', 1)
                ->groupBy('destinations.id')
                ->orderByRaw('COUNT(bookings.id) DESC')
                ->get();
            if(count($explorePlace)){
                    foreach($explorePlace as $row){
                        $row->image = url('uploads/destination/'.$row->image) ?? null;
                    }
                }
    
            // Send response
            return $this->sendResponse($explorePlace, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            // Send error response
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
     * Fetch list here
    **/
    public  function getRulesList(Request $request){
        try{
            $controller = new self(); // Creating an instance of HomeAPIController
            $pagination_no = config('constant.api_pagination');
            if(isset($search['per_page']) && !empty($search['per_page'])){
                $pagination_no = $search['per_page'];
            }
            $resData = Rules::where('status',1)->select('id','name','image')->get();
            
            $response = $controller->sendResponse($resData, __('lang.message_data_retrived_successfully'));  
            return $response;
        } catch (\Exception $ex) {
            return $controller->sendError($ex->getMessage());
        }
    }
    
    /**
     * Save View Hotel
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function saveViewHotel(Request $request)
    {
        try {
            $hotelId = $request->hotelId;
            $userId = $request->userId ?: 0;
            $deviceToken = $request->header('device-token');
            Log::info('Device Token:', ['device_token' => $deviceToken]);
            if (!$deviceToken) {
                return $this->sendError(__('lang.device_token_required'));
            }
            $postData = [
                'user_id' => $userId,
                'device_token' => $deviceToken,
                'hotel_id' => $hotelId,
            ];
            $recentlyViewedHotel = RecentlyViewedHotel::create($postData);
            return $this->sendResponse($recentlyViewedHotel->id, __('lang.admin_data_add_msg'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
    public function recentlyViewHotel(Request $request)
    {
        //   echo"<pre>";print_r($request->all());die;
        try {
             $userId = $request->userId ?: 0;
              
            $deviceToken = $request->header('device-token');
            
            Log::info('Device Token:', ['device_token' => $deviceToken]);
            if (!$deviceToken) {
                return $this->sendError(__('lang.device_token_required'));
            }
          
     $recentlyViewedHotels = RecentlyViewedHotel::leftJoin('hotels', 'hotels.id', '=', 'recently_viewed_hotels.hotel_id')
    ->leftJoin('ratings', 'ratings.hotel_id', '=', 'recently_viewed_hotels.hotel_id')
    ->select(
        'hotels.id as hotel_id', 
        'recently_viewed_hotels.hotel_id as recently_viewed_hotel_id',
        DB::raw('avg(ratings.rating) as rating') 
    )
    ->where('recently_viewed_hotels.user_id', $userId)
    ->where('recently_viewed_hotels.device_token', $deviceToken)
    ->groupBy('hotels.id', 'recently_viewed_hotels.hotel_id')
    ->get();


     
            $recentlyViewedid= [];
            foreach($recentlyViewedHotels as $recentlyViewed){
                $recentlyViewedid[] = Hotel::with(['ratings' => function ($query) {
                    $query->selectRaw('hotel_id, AVG(rating) as avg_rating')
                        ->groupBy('hotel_id');
                }])->where('id', $recentlyViewed->hotel_id)->first();
            }
            //  echo"<pre>";print_r($recentlyViewedid);die;
           
            return $this->sendResponse($recentlyViewedid, __('lang.admin_data_add_msg'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }



       public function vendor_view_hotel(Request $request)
    {
        //   echo"<pre>";print_r($request->all());die;
          try {
            $vendorId = $request->vendor_id ?: 0;

           $hotelbooking =  Hotel::with('bookings')->where('vendor_id',$vendorId)->get();
           
           
              foreach ($hotelbooking as $hotel) {
                $hotel->front_image = url('uploads/hotel/front_image/' . $hotel->front_image);
            }
            // echo"<pre>";print_r($hotelbooking->toArray());die;
            return $this->sendResponse($hotelbooking, __('lang.admin_data_add_msg'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
    
    public function recently_booking(Request $request)
    {
        //   echo"<pre>";print_r($request->all());die;
          try {
           $lastbooking =  Booking::orderBy('id','DESC')->get();
            $hotealldata = [];
            foreach($lastbooking as $lastbookings){
                $hotealldata[] = Hotel::where('id',$lastbookings->hotel_id)->limit(10)->get();
            }

            return $this->sendResponse($hotealldata, __('lang.admin_data_add_msg'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }


    /**
     * Recently View List
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getRecentlyView(Request $request)
    {
        try {
            $pagination_no = config('constant.api_pagination', 10);
            if ($request->has('per_page') && !empty($request->per_page)) {
                $pagination_no = (int) $request->per_page;
            }
            $userId = $request->userId;
            $sessionId = Session::getId();
            $query = RecentlyViewedHotel::query()
                ->where(function ($query) use ($userId, $sessionId) {
                    if ($userId) {
                        $query->where('user_id', $userId);
                    } else {
                        $query->where('session_id', $sessionId);
                    }
                })
                ->orderBy('created_at', 'desc')
                ->pluck('hotel_id')
                ->map(function ($id) {
                    return (int) $id;
                });
            // Fetch hotel details
            $hotels = Hotel::whereIn('id', $query->toArray())
                // ->with(['destination:id,name', 'aminities:id,name'])
                // ->select('id', 'name', 'price', 'type', 'destination_id', 'category_id', 'front_image')
                ->get();
            $hotels->transform(function ($hotel) {
                $hotel->front_image = url('uploads/hotel/front_image/' . $hotel->front_image);
                $hotel->destination_name = $hotel->destination ? $hotel->destination->name : null;
                $hotel->amenities_list = $hotel->aminities->pluck('name');
                if ($hotel->destination) {
                    $hotel->destination = [
                        'id' => $hotel->destination->id,
                        'name' => $hotel->destination->name
                    ];
                }
                return $hotel;
            });
            return $this->sendResponse($hotels, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }




}
