<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\RecentlyViewedHotel;
use Illuminate\Support\Str;
use Auth;
use Validator;
use App\Models\User;
use Illuminate\Support\Facades\Log;
use App\Models\Hotel;
use App\Models\Additional_Info;
use App\Models\Destination;
use App\Models\Feature;
use App\Models\Rules;
use App\Models\Cancellation_Policy;
use App\Models\Specification;
use App\Models\Hotel_Aminities;
use App\Models\{Hotel_Images,State,Payment};
use Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;
use DB;
class PaymentController extends Controller
{

        public function createPayment(Request $request)
        {
            // Validate the incoming request
            $validator = Validator::make($request->all(), [
                'amount' => 'required|numeric',
                'booking_id' => 'required',
                'hotel_id' => 'required',
                'user_id' => 'required'
            ]);
        
            if ($validator->fails()) {
                return response()->json([
                    'status' => 'error',
                    'errors' => $validator->errors()
                ], 422);
            }
        
            // Generate order and session IDs
            $order_id = 'order_' . time();
            $sessionId = 'session_' . Str::random(64);
        
            // Save initial payment details with status pending (0)
            $payment = Payment::create([
                'booking_id' => $request->booking_id,
                'hotel_id' => $request->hotel_id,
                'user_id' => $request->user_id,
                'order_id' => $order_id,
                'session_id' => $sessionId,
                'amount' => $request->amount,
                'payment_status' => 0
            ]);
        
            $url = "https://sandbox.cashfree.com/pg/orders";
        
            // Prepare headers
            $headers = [
                "accept: application/json",
                "Content-Type: application/json",
                "x-api-version: 2023-08-01",
                "x-client-id: " . env("CASHFREE_API_KEY"),
                "x-client-secret: " . env("CASHFREE_API_SECRET")
            ];
        
            // Prepare data for the Cashfree request
            $data = json_encode([
                'order_id' => $order_id,
                'order_amount' => $request->amount,
                'order_currency' => "INR",
                'customer_details' => [
                    'customer_id' => 'customer_' . rand(111111111, 999999999),
                    'customer_name' => 'Test User',
                    'customer_email' => 'testuser@gmail.com',
                    'customer_phone' => '1234567890',
                    'payment_session_id' =>$sessionId,
                ],
    
              'order_meta' => [
            'return_url' => 'https://mystaycations.in/booking-confirmed?booking_id=' . $request->booking_id . '&order_id=' . $order_id,
            // 'payment_method' => [
            //     'card',         // For Visa/Debit/Credit Cards
            //     'upi',          // For UPI options like Paytm UPI
            //     'paylater',     // For any 'Buy Now, Pay Later' options if needed
            //         ]
            
             ]
            ]);
            //  echo"<pre>";print_r($data);die;
            // Send the request to Cashfree API
            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        
            $resp = curl_exec($curl);
    
            // Check if the cURL request failed
            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                curl_close($curl);
        
                return response()->json([
                    'status' => 'error',
                    'message' => 'cURL error: ' . $error_msg
                ], 500);
            }
        
            curl_close($curl);
        
            // Decode the response and check for payment link
            $response = json_decode($resp);
            // echo"<pre>";print_r($response);die;
            if (!$response) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Invalid response from Cashfree',
                    'response' => $resp  // To see the raw response
                ], 500);
            }
        
            if (isset($response->payment_link)) {
                return redirect()->to($response->payment_link);  // Redirect user to Cashfree payment page
            }
        
           return response()->json([
            'status' => 'success',
            'message' => 'Payment created successfully.',
            'response' => $response  // Include response for further debugging
                ], 200);  

        }
        
        
  public function createPaymentapp(Request $request)
{
    // Validate the incoming request
    $validator = Validator::make($request->all(), [
        'amount' => 'required|numeric',
        'booking_id' => 'required',
        'hotel_id' => 'required',
        'user_id' => 'required'
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422);
    }

    // Generate order and session IDs
    $order_id = 'order_' . time();
    $sessionId = 'session_' . Str::random(64);

    // Save initial payment details with status pending (0)
    $payment = Payment::create([
        'booking_id' => $request->booking_id,
        'hotel_id' => $request->hotel_id,
        'user_id' => $request->user_id,
        'order_id' => $order_id,
        'session_id' => $sessionId,
        'amount' => $request->amount,
        'payment_status' => 0
    ]);

    // Prepare Cashfree API URL
    // Sandbox URL for testing, change to the live URL when moving to production
    $url = "https://sandbox.cashfree.com/pg/orders";  // Use live URL for production: https://api.cashfree.com/pg/orders

    // Prepare headers
    $headers = [
        "accept: application/json",
        "Content-Type: application/json",
        "x-api-version: 2023-08-01",
        "x-client-id: " . env("CASHFREE_API_KEY"),
        "x-client-secret: " . env("CASHFREE_API_SECRET")
    ];

    // Prepare data for Cashfree request
    $data = json_encode([
        'order_id' => $order_id,
        'order_amount' => $request->amount,
        'order_currency' => "INR",
        'customer_details' => [
            'customer_id' => 'customer_' . rand(111111111, 999999999),
            'customer_name' => 'Test User', // Replace with actual user name
            'customer_email' => 'testuser@gmail.com', // Replace with actual user email
            'customer_phone' => '1234567890', // Replace with actual user phone number
        ],
        'order_meta' => [
            'return_url' => 'https://mystaycations.in/booking-confirmed?booking_id=' . $request->booking_id . '&order_id=' . $order_id,
        ]
    ]);

    // Send request to Cashfree API
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

    $resp = curl_exec($curl);

    // Check for cURL errors
    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
        curl_close($curl);

        return response()->json([
            'status' => 'error',
            'message' => 'cURL error: ' . $error_msg
        ], 500);
    }

    curl_close($curl);

    // Decode the response and check for payment link
    $response = json_decode($resp);

    if (!$response) {
        return response()->json([
            'status' => 'error',
            'message' => 'Invalid response from Cashfree',
            'response' => $resp  // Raw response for debugging
        ], 500);
    }

    // Handle the payment link response
    if (isset($response->payment_link)) {
        // For React Native or App: Send the payment link in the JSON response
        return response()->json([
            'status' => 'success',
            'payment_link' => $response->payment_link
        ], 200);
    }

    return response()->json([
        'status' => 'success',
        'message' => 'Payment created successfully.',
        'response' => $response  // Include response for further debugging
    ], 200);
}

        
        public function paymentVerify(Request $request)
        {
            // Validate the incoming request
            $validator = \Validator::make($request->all(), [
                'order_id' => 'required',
            ]);
        
            if ($validator->fails()) {
                return response()->json([
                    'status' => 'error',
                    'errors' => $validator->errors()
                ], 422);
            }
        
            // Retrieve order_id from the request
            $order_id = $request->order_id;
        
            // Find the payment record using query builder
           
           
                // Update the payment_status using query builder
               $payment =  DB::table('payment')
                    ->where('order_id', $order_id)
                    ->update(['payment_status' => 1]);
                    
                         // Return a success response
                      return response()->json([
                        'status' => 'success',
                        'message' => 'Payment successful.',
                        'response' => DB::table('payment')
                            ->where('order_id', $order_id)
                            ->first() // Fetch the first matching record
                    ], 200);
            }
        
            



}
