<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Firebase\JWT\JWT;
use Google\Client;
use Google\Service\Drive;
use Session;
use App\Models\{Booking,Hotel};
  use Carbon\Carbon;
  
use Illuminate\Support\Facades\DB;
class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $startOfMonth = Carbon::now()->startOfMonth()->subMonth()->toDateString();
        $todate = Carbon::now()->toDateString();
        $count = Booking::whereBetween('created_at', [$startOfMonth, $todate])->count();
         $farmhouse = Hotel::count();
         
           $customerscount = User::count();
         $bookingcount = Booking::count();
         
        
            $farmhousemonth = Hotel::whereBetween('created_at', [$startOfMonth,$todate])->count();
            
        
                $endDate = Carbon::now();
            $startDate = Carbon::now()->subYear();

        $farmhouseyear = Hotel::whereBetween('created_at', [$startDate, $endDate])->count();




        $hotelWithMaxBookings = DB::table('hotels')
        ->select('hotels.name', DB::raw('COUNT(bookings.id) as bookings_count'))
        ->leftJoin('bookings', 'hotels.id', '=', 'bookings.hotel_id')
        ->groupBy('hotels.id', 'hotels.name')
        ->orderBy('bookings_count', 'desc')
        ->first();
    
        
        $hotelWithMinBookings = DB::table('hotels')
        ->select('hotels.name', DB::raw('COUNT(bookings.id) as bookings_count'))
        ->leftJoin('bookings', 'hotels.id', '=', 'bookings.hotel_id')
        ->groupBy('hotels.id')
        ->orderBy('bookings_count', 'asc')
        ->first();


         $hotelWithMaxBookingsgrap = DB::table('hotels')
            ->select('hotels.name', DB::raw('COUNT(bookings.id) as bookings_count'))
            ->leftJoin('bookings', 'hotels.id', '=', 'bookings.hotel_id')
            ->groupBy('hotels.id', 'hotels.name')
            ->orderBy('bookings_count', 'desc')
            ->limit(11)
            ->get();
            

        $hotelNames = $hotelWithMaxBookingsgrap->pluck('name')->toArray();
        
        $bookingCounts = $hotelWithMaxBookingsgrap->pluck('bookings_count')->toArray();
        
        $minBookingCount = min($bookingCounts);
        $maxBookingCount = max($bookingCounts);

    
        $farmhouselist = Hotel::orderBy('id', 'DESC')->limit(8)->get();
        
        $userlist = User::where('type','user')->where('name','!=','')->orderBy('id', 'DESC')->limit(8)->get();
        // echo"<pre>";print_r($userlist->toArray());die;
                return view('admin.dashboard.index',[
                    'count'=>$count,
                    'farmhouse'=>$farmhouse,
                     'customers'=>$customerscount,
                     'bookingcount'=>$bookingcount,
                     'farmhousemonth'=>$farmhousemonth,
                     'farmhouseyear'=>$farmhouseyear,
                     'hotelWithMaxBookings'=>$hotelWithMaxBookings,
                     'hotelWithMinBookings'=>$hotelWithMinBookings,
                     'hotelNames'=>$hotelNames,
                     'bookingCounts'=>$bookingCounts,
                     'minBookingCount'=>$minBookingCount,
                     'maxBookingCount'=>$maxBookingCount,
                     'farmhouselist'=>$farmhouselist,
                     'userlist'=>$userlist,
                     
                    ]);
    }
}
