<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Package;
use App\Models\Hotel;
use App\Models\Feature;
use App\Models\Aminity;
use App\Models\Rules;
use App\Models\Hotel_Packages;
use App\Models\Destination;
use Session;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;

class HotelController extends Controller
{
    /**
     * Display a listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function index(Request $request)
    {
        try{
            $data['destination_data'] = Destination::where('status','1')->get();
            $data['statusTypes'] = \Helpers::getStatusType();
            $data['result'] = Hotel::getLists($request->all());
            $data['hotelData'] = Hotel::get();
            $data['getType'] = \Helpers::getType();
            $data['package_data'] = Package::where('status','1')->get();
            return view('admin.hotel.list',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    

    /**
     * Display a page.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function create(Request $request)
    {
        $data['rules_data'] = Rules::where('status','1')->get();
        $data['package_data'] = Package::where('status','1')->get();
        $data['destination_data'] = Destination::where('status','1')->get();
        $data['aminity_data'] = Aminity::where('status','1')->get();
        $data['getType'] = \Helpers::getType();
        $data['recommendedType'] = \Helpers::getRecommendedType();
        $data['allowedType'] = \Helpers::allowedType();
        return view('admin.hotel.create',$data);
    }


    /**
     * Store a newly created resource.
     *
     * @param  \App\Http\Requests\Store  $request
     * @return \Illuminate\Http\Response
    **/

    public function store(Request $request)
    {
        
        try{
            $added = Hotel::addUpdate($request->all());
            if($added['status']==true){ 
                Session::flash('success', $added['message']);
                return redirect('admin/hotel')->with('success', $added['message']); 
            }
            else{
                return redirect()->back()->with('error', $added['message']);
            }
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


    /**
     * Display a edit listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function edit(Request $request,$id)
    {
        try{
            $data['result'] = Hotel::with('additionalInfos','destination','cancellationPolicies','specification','hotelAminities','hotelPackages','hotelImages','hotelRules','offdays')->where('id',$id)->first();
            $data['package_data'] = Package::where('status','1')->get();
            $data['destination_data'] = Destination::where('status','1')->get();
            $data['rules_data'] = Rules::where('status','1')->get();
            $data['aminity_data'] = Aminity::where('status','1')->get();
            $data['getType'] = \Helpers::getType();
            $data['recommendedType'] = \Helpers::getRecommendedType();
            $data['allowedType'] = \Helpers::allowedType();
            return view('admin.hotel.edit',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Update the specified in storage.
     *
     * @param  \App\Http\Requests\UpdateRequest  $request
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function update(Request $request)
    {
        try{
            $updated = Hotel::addUpdate($request->all(),$request->input('id'));
            if($updated['status']==true){
                return redirect('admin/hotel')->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Remove the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function destroy($id)
    {
        try{
            $deleted = Hotel::deleteRecord($id);
            
            if($deleted['status']==true){
                return redirect()->back()->with('success', $deleted['message']); 
            }
            else{
                return redirect()->back()->with('error', $deleted['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Remove the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function updateColumn($id)
    {
        try{
            $updated = Hotel::updateColumn($id);
            if($updated['status']==true){
                return redirect()->back()->with('success', $updated['message']);
            }else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
           public function approveColumn($id)
        {
            try {
                $result = Hotel::toggleApprovalStatus($id);
        
                if ($result['success']) {
                    return redirect()->back()->with('success', $result['message']);
                } else {
                    return redirect()->back()->with('error', $result['message']);
                }
            } catch (\Exception $ex) {
                return redirect()->back()->with('error', $ex->getMessage());
            }
        }

    /**
     * view the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/

        public function viewHotel(Request $request,$id)
    {
        try{
            $data['result'] = Hotel::with('cuisines')->where('id',$id)->first();
            $data['itemData'] = Item::getLists($request->all())->where('hotel_id',$id);
            return view('admin.hotel.view',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
    
    
    // ================================vendor================================
    /**
     * Display a listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function vendorIndex(Request $request)
    {
        try{
            $data['destination_data'] = Destination::where('status','1')->get();
            $data['statusTypes'] = \Helpers::getStatusType();
            $data['result'] = Hotel::getVendorLists($request->all());
            $data['hotelData'] = Hotel::get();
            $data['getType'] = \Helpers::getType();
            $data['package_data'] = Package::where('status','1')->get();
            return view('admin.hotel.vendor-hotel.list',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
    /**
     * Display a edit listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function vendorEdit(Request $request,$id)
    {
        try{
            $data['result'] = Hotel::with('additionalInfos','destination','cancellationPolicies','specification','hotelAminities','hotelPackages','hotelImages','hotelRules','offdays')->where('id',$id)->first();
            $data['package_data'] = Package::where('status','1')->get();
            $data['destination_data'] = Destination::where('status','1')->get();
            $data['rules_data'] = Rules::where('status','1')->get();
            $data['aminity_data'] = Aminity::where('status','1')->get();
            $data['getType'] = \Helpers::getType();
            $data['recommendedType'] = \Helpers::getRecommendedType();
            $data['allowedType'] = \Helpers::allowedType();
            return view('admin.hotel.vendor-hotel.edit',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
    
    /**
     * Update the specified in storage.
     *
     * @param  \App\Http\Requests\UpdateRequest  $request
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function vendorUpdate(Request $request)
    {
        try{
            $updated = Hotel::addUpdate($request->all(),$request->input('id'));
            if($updated['status']==true){
                return redirect('admin/vendors-hotel')->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

}
