<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Rules;
use Session;

class RulesController extends Controller
{
    /**
     * Display a listing of the feature.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function index(Request $request)
    {
        try{
            $data['result'] = Rules::getLists($request->all());
            return view('admin.rules.list',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


    /**
     * Display a listing of the Feature.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function create(Request $request)
    { 
        return view('admin.rules.create');
    }


    /**
     * Store a newly created resource in feature.
     *
     * @param  \App\Http\Requests\StoreCategoryRequest  $request
     * @return \Illuminate\Http\Response
    **/

    public function store(Request $request)
    {

        try{
            
            
                $imageName = time() . '.' . $request->image->extension();
                $request->image->move(public_path('uploads/rules'), $imageName);

                // Save the rule with the image path
                $rule = new Rules();
                $rule->name = $request->name;
                 $rule->image = url('uploads/rules/' . $imageName);
                $rule->save();
           
                Session::flash('success','Rules created successfully.');
                return redirect('admin/rules')->with('success', 'Rules created successfully.'); 
    
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


    /**
     * Display a edit listing of the feature.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function edit(Request $request,$id)
    {
        try{
            $data = Rules::where('id',$id)->first();
            return view('admin.rules.edit',compact('data'));
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Update the specified feature in storage.
     *
     * @param  \App\Http\Requests\UpdateCategoryRequest  $request
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function update(Request $request)
    {
        try{
            
              $updated = Rules::findOrFail($request->id);
            
        $updated->name = $request->name;
        
        if ($request->hasFile('image')) {   
            $image = $request->file('image');
            $imageName = time() . '.' . $request->image->extension();
                 $request->image->move(public_path('uploads/rules'), $imageName);
             $updated->image = url('uploads/rules/' . $imageName);
        }

        $updated->save();
            
            
                return redirect('admin/rules')->with('success','Rules update successfully.'); 
         
            
            // $updated = Rules::addUpdate($request->all(),$request->input('id'));
            // if($updated['status']==true){
            //     return redirect('admin/rules')->with('success', $updated['message']); 
            // }
            // else{
            //     return redirect()->back()->with('error', $updated['message']);
            // } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Remove the specified feature from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function destroy($id)
    {
        try{
            $deleted = Rules::deleteRecord($id);
            
            if($deleted['status']==true){
                return redirect()->back()->with('success', $deleted['message']); 
            }
            else{
                return redirect()->back()->with('error', $deleted['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    /**
     * Remove the specified feature from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function updateColumn($id)
    {
        try{
            $updated = Rules::updateColumn($id);
            if($updated['status']==true){
                return redirect()->back()->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

}
