<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\VendorOffer;
use App\Models\Hotel;
use App\Models\CouponRestaurant;
use Illuminate\Support\Facades\Validator;
use Session;

class VendorOfferController extends Controller
{
    /**
     * Display a listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function index(Request $request)
    {

        try{
         $data['result'] = VendorOffer::with('hotel')->paginate(10); 
            return view('admin.vendor_offer.list',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


    /**
     * Display a page.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function create(Request $request)
    { 
        $data['hotels'] = Hotel::where('status',1)->get();

        return view('admin.vendor_offer.create',$data);
    }


    /**
     * Store a newly created resource.
     *
     * @param  \App\Http\Requests\Store  $request
     * @return \Illuminate\Http\Response
    **/

  public function store(Request $request)
{
    try {
        // Validation rules
        $rules = [
            'hotel_id' => 'required|exists:hotels,id',
            'offer' => 'required|string|max:255',
        ];

        // Validation messages
        $messages = [
            'hotel_id.required' => 'Please select a hotel.',
            'hotel_id.exists' => 'The selected hotel does not exist.',
            'offer.required' => 'The offer field is required.',
        ];

        // Validate the request
        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            // Redirect back with validation errors and old input
            return redirect()->back()->withErrors($validator)->withInput();
        }

        // Create new VendorOffer
        $vendorOffer = new VendorOffer();
        $vendorOffer->hotel_id = $request->hotel_id; // Corrected variable name
        $vendorOffer->offer = $request->offer;
        $vendorOffer->save();

        // Set success message
        Session::flash('success', 'Vendor offer added successfully.');
        return redirect('admin/vendor-offer')->with('success', 'Vendor offer added successfully.');
    } catch (\Exception $ex) {
        // Log the error if needed and redirect with error message
        return redirect()->back()->with('error', 'An error occurred: ' . $ex->getMessage());
    }
}


    /**
     * Display a edit listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
  public function edit(Request $request, $id)
{
    try {
        $data['hotels'] = Hotel::where('status', 1)->get();
        $data['offer'] = VendorOffer::findOrFail($id); 
        return view('admin.vendor_offer.edit', $data);
    } catch (\Exception $ex) {
        return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile());
    }
}


    /**
     * Update the specified in storage.
     *
     * @param  \App\Http\Requests\UpdateRequest  $request
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
public function update(Request $request)
{
 
    try {
       $rules = [
            'hotel_id' => 'required|exists:hotels,id',
            'offer' => 'required|string|max:255',
        ];

        // Validation messages
        $messages = [
            'hotel_id.required' => 'Please select a hotel.',
            'hotel_id.exists' => 'The selected hotel does not exist.',
            'offer.required' => 'The offer field is required.',
        ];

        // Validate the request
        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            // Redirect back with validation errors and old input
            return redirect()->back()->withErrors($validator)->withInput();
        }
        // Find the offer by ID
        $vendorOffer = VendorOffer::findOrFail($request->id);
        $vendorOffer->hotel_id = $request->hotel_id;
        $vendorOffer->offer = $request->offer;
        $vendorOffer->save();

        // Redirect to the vendor offers list with success message
        return redirect('admin/vendor-offer')->with('success', 'Offer updated successfully!');
    } catch (\Exception $ex) {
        // Handle exception and redirect back with error message
        return redirect()->back()->with('error', $ex->getMessage() . ' on line ' . $ex->getLine() . ' in ' . $ex->getFile());
    }
}

    /**
     * Remove the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
      public function destroy($id)
    {
        try{
           $deleted = VendorOffer::deleteRecord($id);
            
            if($deleted['status']==true){
                return redirect()->back()->with('success', $deleted['message']); 
            }
            else{
                return redirect()->back()->with('error', $deleted['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


}
