<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Videocontent;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;

class VideoContentController extends Controller
{
    
    public function index(Request $request)
    {
     $videos = VideoContent::first();
        return view('admin.videocontent.index',['videos'=>$videos
            ]);
    }
    
    
public function store(Request $request)
{
    // Validate the video file
    $request->validate([
        'video' => 'required', // Optional: Add validation rules for file types and size
    ]);

    // Handle video upload
    if ($request->hasFile('video')) {
        $video = $request->file('video');
        $videoName = time() . '_' . $video->getClientOriginalName();

        // Define the path to store the video
        $destinationPath = public_path('uploads/videocontent');

        // Move the uploaded video file to the specified directory
        $video->move($destinationPath, $videoName);

        // Check if there is an existing Videocontent record
        $videoContentupdate = Videocontent::first(); // Assuming you want the first record

        if ($videoContentupdate) {
            $videoContentupdate->video_path = 'uploads/videocontent/' . $videoName;
            $videoContentupdate->save();
        } else {
            // Create a new video content record
            $videoContent = new Videocontent();
            $videoContent->video_path = 'uploads/videocontent/' . $videoName;
            $videoContent->save();
        }

        return redirect()->back()->with('success', 'Video uploaded successfully!');
    }

    return redirect()->back()->with('error', 'Video upload failed!');
}





}
