<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AuthenticateUserApi
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    // public function handle(Request $request, Closure $next): Response
    //         {
                
    //             if ($request->is('api/*')) { 
    //                 $token = $request->header('Authorization');
    //                 if ($token == null) {
    //                     return redirect()->route('authentication-failed');
    //                 } else {
    //                     $tokenData = \Helpers::validateAuthToken($token);
    //                     if (!$tokenData) {
    //                         return redirect()->route('authentication-failed');
    //                     } else {
    //                         $request->merge(['user' => $tokenData]);
    //                         return $next($request);
    //                     }
    //                 }
    //             } else if ($request->is('/*') || $request->is('/*')) {
    //                 return route('doLogin');
    //             } else {
    //                 return route('doLogin');
    //             }
    //         }
    
     public function handle(Request $request, Closure $next): Response
    {
        if ($request->is('api/*')) { 
            // Extract Bearer token from Authorization header
            $token = str_replace('Bearer ', '', $request->header('Authorization'));
            
            if (!$token) {
                return response()->json(['error' => 'Authentication token missing'], 401);
            }

            // Validate the token
            $tokenData = \Helpers::validateAuthToken($token);
            if (!$tokenData) {
                return response()->json(['error' => 'Invalid token'], 401);
            }

            // Merge token data with request to use later in the app
            $request->merge(['user' => $tokenData]);

            // Proceed with the request
            return $next($request);
        } 

        return redirect()->route('doLogin');
    }
}
