<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Coupon extends Model
{
    
    use HasFactory;
    protected $guarded = ['id'];
    protected $table = "coupons";


    public function hotels()
    {
        return $this->belongsToMany(Hotel::class, 'coupon_hotels', 'coupon_id', 'hotel_id');
    }

    public function customers()
    { 
        return $this->belongsToMany(User::class, 'coupon_customers', 'coupon_id', 'customer_id');
    }
    
    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }
    
    /**
     * Fetch list of from here
    **/
    public static function getLists($search){
        try {
            
            $obj = new self;

            $pagination = (isset($search['perpage']))?$search['perpage']:config('constant.pagination');

            if(isset($search['name']) && !empty($search['name'])){
                $obj = $obj->orWhere('title', 'like', '%'.trim($search['name']).'%')
                           ->orWhere('code', 'like', '%'.trim($search['name']).'%');
            }

            if(isset($search['discount_type']) && $search['discount_type']!=''){
                $obj = $obj->where('discount_type',$search['discount_type']);
            } 

            if(isset($search['status']) && $search['status']!=''){
                $obj = $obj->where('status',$search['status']);
            } 

            $data = $obj->with('hotels', 'customers')->orderBy('id', 'DESC')->paginate($pagination)->appends('perpage', $pagination);

            return $data;
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Add or update
    **/
    public static function addUpdate($data,$id=0) {
      
        try {
            $obj = new self;
            $hotel_id_arr = $data['hotel_id'];
            $customer_id_arr = $data['customer_id'];
            unset($data['_token']);
            unset($data['hotel_id']);
            unset($data['customer_id']);
          
            if($id==0){
                $data['created_at'] = date('Y-m-d H:i:s');
                $coupon_id = $obj->insertGetId($data);

                if(isset($hotel_id_arr) && $hotel_id_arr!=''){
                    foreach ($hotel_id_arr as $key => $value) {
                        $data = array(
                            'hotel_id'=> $value,
                            'coupon_id' => $coupon_id
                        );
                        CouponHotel::create($data);
                    }
                }
                if(isset($customer_id_arr) && $customer_id_arr!=''){
                    foreach ($customer_id_arr as $key => $value) {
                        $data = array(
                            'customer_id'=> $value,
                            'coupon_id' => $coupon_id
                        );
                        CouponCustomer::create($data);
                    }
                }

                return ['status' => true, 'message' => __('lang.admin_data_add_msg')];
            }
            else{
                $data['updated_at'] = date('Y-m-d H:i:s');
                $obj->where('id',$id)->update($data);

                CouponHotel::where('coupon_id',$id)->delete();

                if(isset($hotel_id_arr) && $hotel_id_arr!=''){
                    foreach ($hotel_id_arr as $key => $value) {
                        $data = array(
                            'hotel_id'=> $value,
                            'coupon_id' => $id
                        );
                        CouponHotel::create($data);
                    }
                }

                CouponCustomer::where('coupon_id',$id)->delete();

                if(isset($customer_id_arr) && $customer_id_arr!=''){
                    foreach ($customer_id_arr as $key => $value) {
                        $data = array(
                            'customer_id'=> $value,
                            'coupon_id' => $id
                        );
                        CouponCustomer::create($data);
                    }
                }

                return ['status' => true, 'message' => __('lang.admin_data_update_msg')];
            }  
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Delete particular
    **/
    public static function deleteRecord($id) {
        try {
            $obj = new self;    
            $obj->where('id',$id)->delete();   
            return ['status' => true, 'message' => __('lang.admin_data_delete_msg')];
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Update Columns 
    **/
    public static function updateColumn($id){
        try {
            $data = self::where('id', $id)->first();

            // Assuming 'status' is an ENUM column with values '0' and '1'
            $newStatus = ($data->status == '1') ? '0' : '1';

            $data->update(['status' => $newStatus]);

            return ['status' => true, 'message' => __('lang.admin_data_change_msg')];
        } catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile()];
        }
    }

}
