<?php

namespace App\Models; 

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HotelFeature extends Model
{
    use HasFactory;

    protected $guarded = ['id']; 
    protected $table = "hotel_features";

    // Define the relationship with the Feature model
    public function feature()
    {
        return $this->belongsTo(Feature::class, 'feature_id');
    }
    
    // Define the relationship with the Hotel model
    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id');
    }
}
