<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Hotel_Packages extends Model
{
    use HasFactory, SoftDeletes; 

    protected $table = 'hotel_packages';
    protected $fillable = ['hotel_id', 'packages_id', 'guest', 'price', 'type', 'date'];

    // Relationship with Hotel
    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id');
    }

    // Relationship with Package
    public function package()
    {
        return $this->belongsTo(Package::class, 'packages_id');
    }
}
