<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;
    protected $table = 'notifications';
    protected $fillable = [
        'booking_id',
        'vendor_id',
    ];
    
      public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'vendor_id');
    }
    
     public function booking()
    {
        return $this->belongsTo(Booking::class,'booking_id');
    }
 
}
