<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Eloquent\SoftDeletes;
use DB;
use Illuminate\Support\Facades\Hash;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable,HasRoles;
    use SoftDeletes;
    
    public function coupons()
    {
    return $this->belongsToMany(Coupon::class, 'coupon_customers', 'customer_id', 'coupon_id');
    }
    
    public function cancelBookings()
    {
        return $this->hasMany(CancelBooking::class);
    }
    
    public function recentlyViewedHotels()
    {
        return $this->hasMany(RecentlyViewedHotel::class);
    }
    
    public function ratings()
    {
        return $this->hasMany(Rating::class);
    }
    
    public function wallets() 
    {
        return $this->hasMany(Wallet::class, 'customer_id');
    }
    
    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    /**
     * admin Login
    **/
    public static function adminLogin($data){
        try {
            $obj = new Self;
            $credentials = [
                'email' => $data['email'],
                'password' => $data['password'],
            ];
            $user = $obj->where('email',$data['email'])->first();
            if ($user) {
                if($user->status != 1){
                    return ['status' => false, 'message' => config('constant.common.messages.your_account_has_been_suspended')];
                }
                if (Auth::attempt($credentials)) {
                     return ['status' => true, 'message' => __('lang.admin_welcome_msg')];
                }else{
                    if ($obj->where('email', $data['email'])->exists()) {
                        return ['status' => false, 'message' => __('lang.admin_incorrect_password')];
                    }
                    return ['status' => false, 'message' => __('lang.admin_invalid_email_password')];
                }
            }else{
                return ['status' => false, 'message' => __('lang.admin_invalid_email_password')];
            }
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Admin Forget Password
    **/
    public static function adminForgetPassword($data){
        try {
            $obj = new Self;
           
            $credentials = [
                'email' => $data['email'],
            ];
            $user = $obj->where('email',$data['email'])->first();
            // where('type','!=','user')->
            if ($user) {
                if($user){
                    $otp = rand(1000,9999);             
                    $data = array();
                    $data['otp'] = $otp;    
                    $data['name'] = $user->name;
                    $data['text'] = __('lang.admin_verification_msg') . $otp;
                    //Todo Email
                    $c = \Helpers::sendEmail('emails.forgot-password',$data,$user->email,$user->name, setting('site_name'). ' forgot password '.$data['otp'], setting('site_name'),'8210jp@gmail.com','');
                    User::where('id',$user->id)->update(['otp'=>$otp]);
                    return ['status' => true, 'data' => $data, 'message' => __('lang.message_otp_sent_success')];
                }
            }else{
                return ['status' => false, 'message' => __('lang.message_user_not_found')];
            }
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Admin Reset Password
    **/
    public static function adminResetPassword($data){
        $obj = new Self;
            $credentials = [
                'otp' => $data['otp'],
                'password' => $data['password'],
                'cpassword' => $data['cpassword'],
            ];
            $user = $obj->where('otp',$data['otp'])->where('type','!=','user')->first();
            if ($user) {
                if($user){
                    $inject = array();
                    if($data['password'] && $data['password'] != ''){
                        $inject['password'] = bcrypt($data['password']);
                        $inject['otp'] = 0;
                    }
                    User::where('id',$user->id)->update($inject);
                    return ['status' => true, 'data' => $user, 'message' => __('lang.message_password_reset_success')];
                }
            }else{
                return ['status' => false, 'message' => __('lang.message_user_not_found')];
            }

    }


    /**
     * Fetch particular admin profile detail
    **/
    public static function getProfile()
    {
        try 
        {
            $obj = new self;
            $id = Auth::user()->id;
            $data = $obj->where('id',$id)->firstOrFail();
            return $data;
        }
        catch (\Exception $e) 
        {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Update admin profile
    **/
    public static function updateProfile($data,$id) 
    {
        try 
        {
            $obj = new self;
            unset($data['_token']);
            if(isset($data['image']) && $data['image']!=''){
                $uploadImage = \Helpers::uploadFiles($data['image'],'user/');
                if($uploadImage['status']==true){
                    $data['image'] = $uploadImage['file_name'];
                }
            }
            if (empty($data['password'])) 
            {
                unset($data['password']);
            } 
            else 
            {
                $data['password'] = Hash::make($data['password']);
            }
            $data['updated_at'] = date('Y-m-d H:i:s'); 
            $obj->where('id',$id)->update($data);
            return ['status' => true, 'message' => __('lang.admin_data_update_msg')];
        }
        catch (\Exception $e) 
        {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }

    }
    
    /**
     * Fetch list from here
    **/
    public static function getCustomerLists($search)
    {
        try {
            
            $obj = new self;

            $pagination = (isset($search['perpage']))?$search['perpage']:config('constant.pagination');

            if(isset($search['name']) && !empty($search['name'])){
                 $obj = $obj->orWhere('name', 'like', '%'.trim($search['name']).'%')
                           ->orWhere('email', 'like', '%'.trim($search['name']).'%');
            } 

            if(isset($search['status']) && $search['status']!=''){
                $obj = $obj->where('status',$search['status']);
            } 
    
            $data = $obj->where('type','user')->where('name','!=','')->orderBy('id', 'DESC')->paginate($pagination)->appends('perpage', $pagination);

            return $data;
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
    
    /**
     * Add or update record
    **/
    public static function addUpdate($data,$id=0) {
      
        try {
            $obj = new self;
            unset($data['_token']);
          
            if($id==0){
                $data['created_at'] = date('Y-m-d H:i:s');
                $category_id = $obj->insertGetId($data);
                return ['status' => true, 'message' => __('lang.admin_data_add_msg')];
            }
            else{
                $data['updated_at'] = date('Y-m-d H:i:s');
                $obj->where('id',$id)->update($data);
                return ['status' => true, 'message' => __('lang.admin_data_update_msg')];
            }  
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Delete particular record
    **/
    public static function deleteRecord($id) {
        try {
            $obj = new self;    
            $obj->where('id',$id)->delete();   
            return ['status' => true, 'message' => __('lang.admin_data_delete_msg')];
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    /**
     * Update Columns 
    **/
    public static function updateColumn($id){
        try {
            $data = self::where('id', $id)->first();

            // Assuming 'status' is an ENUM column with values '0' and '1'
            $newStatus = ($data->status == '1') ? '0' : '1';

            $data->update(['status' => $newStatus]);

            return ['status' => true, 'message' => __('lang.admin_data_change_msg')];
        } catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile()];
        }
    }
    
    


}
