<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorOffer  extends Model
{
    use HasFactory;
    protected $table = 'venodor_offers';
    protected $fillable = [
        'hotel_id',
        'offer',
    ];
    
     public function hotel()
    {
        return $this->belongsTo(Hotel::class,'hotel_id');
    }
    
     public static function deleteRecord($id) {
        try {
            $obj = new self;    
            $obj->where('id',$id)->delete();   
            return ['status' => true, 'message' => __('lang.admin_data_delete_msg')];
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
 
}
