@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">


    <form action="{{url('admin/update-hotel')}}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="row">
            <div class="col-md-6">
                <h4 class="py-3 mb-4">
                  <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
                  </span><span class="text-muted fw-light">
                    <a href="{{url('admin/items')}}">{{__('lang.admin_hotel_list')}}</a> /
                  </span>
                  {{__('lang.admin_edit_hotel_form')}}</h4>
            </div>
            <div class="col-md-6">
                <div class="table-btn-css">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        <span class="ti-xs ti ti-plus me-1"></span>{{__('lang.admin_update')}}
                    </button>
                    <a type="reset" class="btn btn-outline-secondary" href="{{url('admin/hotel')}}">{{__('lang.admin_back')}}</a>
                </div>
            </div>
        </div>
        

        <!-- Hotel add -->
        <div class="row">
                  <!-- First column-->
                  <div class="col-12 col-lg-8">
                    <!-- Basic Information -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-tile mb-0">{{__('lang.admin_hotel_basic')}}</h5>
                      </div>
                      <div class="card-body row">
                          <!--id-->
                        <input type="hidden" name="id" value="{{$result->id}}">
                        <!-- Destination -->
                        <div class="mb-3 col-12 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                          <span>{{__('lang.admin_destination')}}</span><a href="{{url('admin/destination')}}" class="fw-medium">{{__('lang.admin_add_new_destination')}}</a>
                          </label>
                          <select class="select2 form-select" name="destination_id">
                                <option value="">{{__('lang.admin_select_destination')}}</option>
                                @if(count($destination_data))
                                     @foreach($destination_data as $destination)
                                           <option <?=$destination->id == $result->destination_id ? 'selected' : '';?> value="{{ $destination->id }}">{{ $destination->name }}</option>
                                        @endforeach
                              @endif
                             
                          </select>
                        </div>
                        
                        <!-- name -->
                        <div class="col-12">
                            <div class="mb-3">
                              <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_name')}} <span class="required">*</span></label>
                              <input
                                type="text"
                                class="form-control"
                                id="ecommerce-product-name"
                                placeholder="{{__('lang.admin_name_placeholder')}}"
                                name="name"
                                aria-label="{{__('lang.admin_name')}}" required
                                value="{{ $result->name }}">
                            </div>
                        </div>
                         
                         <!--Profile Image -->
                        <div class="col-6">
                          <div class="mb-3">
                              <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_profile_image')}} <span class="required">*</span></label>
                              <div class="avatar-upload">
                                  <div class="avatar-edit">
                                          <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="front_image" required>
                                          <label for="imageUpload"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                      </div>
                                      <div class="avatar-preview">
                                          <div id="imagePreview" style='background-image: url("{{asset('/uploads/hotel/front_image/'.$result->front_image)}}");'>
                                          </div>
                                      </div>
                              </div>
                          </div>
                        </div>
                        
                         <!--Document Image -->
                        <div class="col-6">
                          <div class="mb-3">
                              <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_licence_document')}} <span class="required">*</span></label>
                              <div class="avatar-upload">
                                  <div class="avatar-edit">
                                          <input type='file' id="imageUploadTwo" accept=".png, .jpg, .jpeg" name="license_document" required>
                                          <label for="imageUploadTwo"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                      </div>
                                      <div class="avatar-preview">
                                          <div id="imagePreviewTwo" style='background-image: url("{{asset('/uploads/hotel/license_documents/'.$result->license_document)}}");'>
                                          </div>
                                      </div>
                              </div>
                          </div>
                        </div>
                        
                        <!-- Description -->
                        <div class="mb-3">
                            <label class="form-label" for="editor">{{__('lang.admin_description')}} <span class="required">*</span></label>
                            <textarea class="form-control" name="description" id="editor" placeholder="{{__('lang.admin_description_placeholder')}}" row="6">{!! $result->description !!}</textarea>
                        </div>


                      </div>
                    </div>
                    <!-- /Basic Information -->

                    <!-- Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_location_information')}}</h5>
                      </div>
                      <div class="card-body row">

                        <!-- address -->
                        <div class="mb-3">
                            <label class="form-label" for="short_description">{{__('lang.admin_address')}} <span class="required">*</span></label>
                            <textarea class="form-control" name="address" placeholder="{{__('lang.admin_address_placeholder')}}" row="6">{!! $result->address !!}</textarea>
                        </div>
                        
                        <!--latitude-->
                        <div class="mb-3">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_latitude')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="latitude_id"
                              name="latitude"
                              aria-label="{{__('lang.admin_latitude')}}" 
                              value="17.4127332"
                              required
                              readonly
                              value="{{ $result->latitude }}"/>
                          </div>
                            
                        <!--longitude-->
                         <div class="mb-3">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_longitude')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="longitude_id"
                              name="longitude"
                              aria-label="{{__('lang.admin_longitude')}}"
                              value="78.078363"
                              readonly
                              required
                              value="{{ $result->longitude }}"/>
                         </div>
                        

                      </div>
                    </div>
                    <!-- /Info -->

                    <!-- Additional Data -->
                    <div class="card mb-4">
                    <div class="card-header">
                    <h5 class="card-title mb-0">{{ __('lang.admin_additional_data') }}</h5>
                    </div>
                    <div class="card-body row" id="additional-points-container">
                    <!-- Existing additionalInfos data -->
                    @if(isset($result->additionalInfos) && $result->additionalInfos->count())
                      @foreach($result->additionalInfos as $info)
                        <div class="row additional-input">
                          <div class="col-10 mb-3">
                            <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_additional_point') }} <span class="required">*</span></label>
                            <input type="text" class="form-control" name="additional_title[]" value="{{ $info->title }}" aria-label="{{ __('lang.admin_additional_placeholder') }}" required placeholder="{{ __('lang.admin_additional_placeholder') }}">
                          </div>
                          <div class="col-2 mt-4">
                            <button type="button" class="btn btn-sm btn-danger" onclick="showDeleteConfirmation('additional-delete', {{ $info->id }})"><i class="ti ti-trash me-1"></i></button>
                          </div>
                        </div>
                      @endforeach
                    @endif
                    <!-- Initial input field -->
                    <div class="row additional-input">
                      <div class="col-10 mb-3">
                        <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_additional_point') }} <span class="required">*</span></label>
                        <input type="text" class="form-control" name="additional_title[]" aria-label="{{ __('lang.admin_additional_placeholder') }}" required placeholder="{{ __('lang.admin_additional_placeholder') }}">
                      </div>
                      <div class="col-2 mt-4">
                        <button type="button" class="btn btn-sm btn-info" onclick="appendData('additional')"><i class="ti ti-plus me-1"></i></button>
                      </div>
                    </div>
                    </div>
                    </div>
                    <!-- /Additional Data -->

                    <!-- Cancellation Policy Data -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('lang.admin_cancellation_policy') }}</h5>
                      </div>
                      <div class="card-body row" id="cancellation-points-container">
                        <!-- Existing cancellationPolicies data -->
                        @if(isset($result->cancellationPolicies) && $result->cancellationPolicies->count())
                          @foreach($result->cancellationPolicies as $policy)
                            <div class="row cancellation-input">
                              <div class="col-10 mb-3">
                                <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_cancellation_point') }} <span class="required">*</span></label>
                                <input type="text" class="form-control" name="cancellation_policy_title[]" value="{{ $policy->title }}" aria-label="{{ __('lang.admin_cancellation_placeholder') }}" required placeholder="{{ __('lang.admin_cancellation_placeholder') }}">
                              </div>
                              <div class="col-2 mt-4">
                                <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'cancellation_policy')"><i class="ti ti-trash me-1"></i></button>
                              </div>
                            </div>
                          @endforeach
                        @endif
                    
                        <!-- Initial input field for adding new data -->
                        <div class="row cancellation-input">
                          <div class="col-10 mb-3">
                            <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_cancellation_point') }} <span class="required">*</span></label>
                            <input type="text" class="form-control" name="cancellation_policy_title[]" aria-label="{{ __('lang.admin_cancellation_placeholder') }}" required placeholder="{{ __('lang.admin_cancellation_placeholder') }}">
                          </div>
                          <div class="col-2 mt-4">
                            <button type="button" class="btn btn-sm btn-info" onclick="appendData('cancellation_policy')"><i class="ti ti-plus me-1"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <!-- /Cancellation Policy Data -->

                    
                                        <!-- Specification Data -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('lang.admin_specification_policy') }}</h5>
                      </div>
                      <div class="card-body row" id="specification-points-container">
                        <!-- Existing specification data -->
                        @if(isset($result->specification) && $result->specification->count())
                          @foreach($result->specification as $spec)
                            <div class="row specification-input">
                              <div class="col-10 mb-3">
                                <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_specification_point') }} <span class="required">*</span></label>
                                <input type="text" class="form-control" name="specification_title[]" value="{{ $spec->title }}" aria-label="{{ __('lang.admin_specification_placeholder') }}" required placeholder="{{ __('lang.admin_specification_placeholder') }}">
                              </div>
                              <div class="col-2 mt-4">
                                <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'specification')"><i class="ti ti-trash me-1"></i></button>
                              </div>
                            </div>
                          @endforeach
                        @endif
                    
                        <!-- Initial input field for adding new data -->
                        <div class="row specification-input">
                          <div class="col-10 mb-3">
                            <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_specification_point') }} <span class="required">*</span></label>
                            <input type="text" class="form-control" name="specification_title[]" aria-label="{{ __('lang.admin_specification_placeholder') }}" required placeholder="{{ __('lang.admin_specification_placeholder') }}">
                          </div>
                          <div class="col-2 mt-4">
                            <button type="button" class="btn btn-sm btn-info" onclick="appendData('specification')"><i class="ti ti-plus me-1"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <!-- /Specification Data -->


                  </div>
                  <!-- /First column -->

                  <!-- Second column -->
                  <div class="col-12 col-lg-4">


                    <!-- Pricing Card -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_pricing')}}</h5>
                      </div>
                      <div class="card-body">

                        <!-- Item Price -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_item_price')}} <span class="required">*</span></label>
                          <input
                            type="number"
                            name="price"
                            class="form-control"
                            id="price_id"
                            value="{{$result->price}}"
                            placeholder="{{__('lang.admin_item_price')}}"
                            aria-label="{{__('lang.admin_item_price')}}" required/>
                        </div>

                        <!-- Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_type')}} <span class="required">*</span></label>
                          <select class="select2 form-select" name="type">
                            <option value="">{{__('lang.admin_select_type')}}</option>
                                @if(count($getType))
                                    @foreach($getType as $value => $label)
                                        <option value="{{ $value }}" {{ $value == $result->type ? 'selected' : '' }}>{{ $label }}</option>
                                    @endforeach
                                @endif
                          </select>
                        </div>
        
                      </div>
                    </div>
                    <!-- /Pricing Card -->


                    <!-- Site Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_site_info')}}</h5>
                      </div>
                      <div class="card-body">
                          
                        <!-- Adults -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_guest')}}</label>
                          <select class="select2 form-select" name="guest">
                                <option value="">{{__('lang.admin_select_guest')}}</option>
                                {!! \Helpers::fiftyCountData($result->guest) !!}
                          </select>
                        </div>
                        
                        <!-- Phone -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_phone')}} <span class="required">*</span></label>
                          <input
                            type="tel"
                            name="phone"
                            class="form-control"
                            id="ecommerce-product-price"
                            placeholder="+91XXXXXXXXXX"
                            aria-label="{{__('lang.admin_phone')}}" maxlength="10" required
                            value="{{ $result->phone }}"/>
                        </div>

        
                      </div>
                    </div>
                    <!-- /Site Info -->
                    
                    <!-- Category & Aminty Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_category_and_aminity_info')}}</h5>
                      </div>
                      <div class="card-body">
                          
                        <!-- Category -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                          <span>{{__('lang.admin_category')}}</span><a href="{{url('admin/category')}}" class="fw-medium">{{__('lang.admin_add_new_category')}}</a>
                          </label>
                          <select class="select2 form-select" name="category_id">
                                <option value="">{{__('lang.admin_select_category')}}</option>
                                @if(isset($category_data) && count($category_data))
                                    @foreach($category_data as $cat)
                                        <option value="{{ $cat->id }}" {{ $cat->id == $result->category_id ? 'selected' : '' }}>
                                            {{ $cat->name }}
                                        </option>
                                    @endforeach
                                @endif
                          </select>
                        </div>
                        
                        <!-- aminity -->
                        @php
                        // PHP Section: Fetching Selected Aminities
                        $selectedAminities = isset($result->aminities) ? $result->aminities->pluck('id')->toArray() : [];
                        @endphp
                        <!-- aminity -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1 d-flex justify-content-between align-items-center" for="category-org">
                            <span>{{ __('lang.admin_aminity') }}</span>
                            <a href="{{ url('admin/aminity') }}" class="fw-medium">{{ __('lang.admin_add_new_aminity') }}</a>
                          </label>
                          <select class="select2 form-select" multiple name="aminities_id[]">
                            <option value="">{{ __('lang.admin_select_aminity') }}</option>
                            @if(isset($aminity_data) && count($aminity_data))
                              @foreach($aminity_data as $aminity)
                                <option value="{{ $aminity->id }}" {{ in_array($aminity->id, $selectedAminities) ? 'selected' : '' }}>
                                  {{ $aminity->name }}
                                </option>
                              @endforeach
                            @endif
                          </select>
                        </div>

        
                      </div>
                    </div>
                    <!-- /Category & Aminty Info -->
                    
                                        <!-- Packages Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <div class="row">
                          <div class="col-10">
                            <h5 class="card-title mb-0">{{ __('lang.admin_packages_info') }}</h5>
                          </div>
                          <div class="col-2">
                            <button type="button" class="btn btn-sm btn-info" onclick="appendData('packages')"><i class="ti ti-plus me-1"></i></button>
                          </div>
                        </div>
                      </div>
                      <div class="card-body">
                        <!-- Existing packages data -->
                        @if(isset($result->packages) && $result->packages->count())
                          @foreach($result->packages as $package)
                          @php
                          $selectedGuest = isset($package->pivot) ? $package->pivot->guest : null;
                          @endphp
                            <div class="card mb-4 packages-input">
                              <div class="card-header">
                                <div class="row">
                                  <div class="col-10">
                                    <h5 class="card-title mb-0">{{ __('lang.admin_packages_info') }}</h5>
                                  </div>
                                  <div class="col-2">
                                    <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'packages')"><i class="ti ti-trash me-1"></i></button>
                                  </div>
                                </div>
                              </div>
                              <div class="card-body">
                                <!-- Package -->
                                <div class="mb-3 col ecommerce-select2-dropdown">
                                  <label class="form-label mb-1 d-flex justify-content-between align-items-center" for="category-org">
                                    <span>{{ __('lang.admin_package') }}</span><a href="{{ url('admin/package') }}" class="fw-medium">{{ __('lang.admin_add_new_package') }}</a>
                                  </label>
                                  <select class="select2 form-select" name="packages_id[]">
                                    <option value="">{{ __('lang.admin_select_package') }}</option>
                                    @if(isset($package_data) && !is_null($package_data) && count($package_data))
                                      @foreach($package_data as $packageOption)
                                        <option value="{{ $packageOption->id }}" {{ $packageOption->id == $package->id ? 'selected' : '' }}>{{ $packageOption->name }}</option>
                                      @endforeach
                                    @endif
                                  </select>
                                </div>
                                <!-- Item Price -->
                                <div class="mb-3">
                                  <label class="form-label" for="ecommerce-product-price">{{ __('lang.admin_item_price') }} <span class="required">*</span></label>
                                  <input type="number" name="package_price[]" class="form-control" value="{{ $package->pivot->price }}" id="price_id" placeholder="{{ __('lang.admin_item_price') }}" aria-label="{{ __('lang.admin_item_price') }}" required/>
                                </div>
                                <!-- Type -->
                                <div class="mb-3 col ecommerce-select2-dropdown">
                                  <label class="form-label mb-1" for="vendor">{{ __('lang.admin_type') }} <span class="required">*</span></label>
                                  <select class="select2 form-select" name="package_type[]">
                                    <option value="">{{ __('lang.admin_select_type') }}</option>
                                    @if(isset($getType) && !is_null($getType) && count($getType))
                                      @foreach($getType as $value => $label)
                                        <option value="{{ $value }}" {{ $value == $package->pivot->type ? 'selected' : '' }}>{{ $label }}</option>
                                      @endforeach
                                    @endif
                                  </select>
                                </div>
                                <!-- Adults -->
                                <div class="mb-3 col ecommerce-select2-dropdown">
                                  <label class="form-label mb-1" for="vendor">{{ __('lang.admin_guest') }}</label>
                                  <select class="select2 form-select" name="package_guest[]">
                                    <option value="">{{ __('lang.admin_select_guest') }}</option>
                                    {!! \Helpers::fiftyCountData($package->pivot->guest) !!}
                                  </select>
                                </div>
                                <!-- Date -->
                                <div class="mb-3">
                                  <label class="form-label" for="ecommerce-product-price">{{ __('lang.admin_date') }} <span class="required">*</span></label>
                                  <input type="date" name="package_date[]" class="form-control" value="{{ $package->pivot->date }}" id="price_id" placeholder="{{ __('lang.admin_date') }}" aria-label="{{ __('lang.admin_date') }}" min="{{ date('Y-m-d') }}" required/>
                                </div>
                              </div>
                            </div>
                          @endforeach
                        @endif
                      </div>
                    </div>
                    
                    <div class="card-body row" id="packages-points-container">
                    </div>
                    <!-- /Packages Info -->

                    
                    <!-- Images -->
                    @if($result && $result->hotelImages->count())
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">{{__('lang.admin_images')}}</h5>
                        </div>
                        <div class="card-body">
                            <!-- Profile Image -->
                            <div class="mb-3">
                                <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_upload_images')}} <span class="required">*</span></label>
                                <div class="avatar-upload">
                                    @foreach($result->hotelImages as $image)
                                    <div class="avatar-preview">
                                        <div id="imageUpload" style='background-image: url("{{asset('/uploads/hotel/images/'.$image->images)}}");'>
                                          </div>
                                      </div>
                                    @endforeach 
                                    <div class="avatar-edit">
                                        <input type='file' id="imageUploadThree" accept=".png, .jpg, .jpeg" name="images[]" multiple required>
                                        <label for="imageUploadThree"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                    </div>
                                    <div class="avatar-preview" id="imagePreviewContainer">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    <!-- /Images -->


                  </div>
                  <!-- /Second column -->
                </div>
        <!-- end Hotel add -->

    </form>
       

    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
