@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">

  <form action="{{ url('admin/save-blockdate') }}" method="post" enctype="multipart/form-data">
    @csrf

    <div class="row">
        <!-- Title and breadcrumb section -->
        <div class="col-md-12">
            <h4 class="py-3 mb-4">
                <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">Block Date</a> /
                </span>
            </h4>
        </div>
    </div>

    <!-- Hotel add -->
    <div class="row">
        <!-- Hotel selection section -->
        <div class="col-12 col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Block Dates for Hotel</h5>
                </div>
                <div class="card-body row">
                    <!-- Hotel dropdown -->
                    <div class="mb-3 col-12 col-lg-6 ecommerce-select2-dropdown">
                        <label class="form-label mb-1 d-flex justify-content-between align-items-center" for="hotel_id">
                            Hotel <span class="text-danger">*</span>
                        </label>
                        <select class="select2 form-select" name="hotel_id" id="hotel_id" required>
                            <option value="">Select Hotel</option>
                            @foreach($hotels as $hotel)
                                <option value="{{ $hotel->id }}">{{ $hotel->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Block Dates Section -->
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label" for="dates">Dates <span class="required">*</span></label>
                            <input type="date" class="form-control" id="dates" placeholder="Select Date" name="block_dates[]" required>
                            <small class="form-text text-muted">Click to add more dates.</small>
                            <button type="button" id="add-date" class="btn btn-secondary mt-2">Add Another Date</button>
                        </div>
                        <div id="additional-dates"></div>
                    </div>

                    <!-- Submit Button -->
                    <div class="col-12">
                        <div class="table-btn-css">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                <span class="ti-xs ti ti-plus me-1"></span>Submit
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end Hotel add -->
</form>
    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->
<script>
     document.getElementById('add-date').addEventListener('click', function () {
        var newDateField = document.createElement('div');
        newDateField.classList.add('mb-3');
        newDateField.innerHTML = `
            <input type="date" class="form-control" name="block_dates[]">
            <button type="button" class="btn btn-danger mt-2 remove-date">Remove</button>
        `;
        document.getElementById('additional-dates').appendChild(newDateField);

        // Add event listener for the remove button
        newDateField.querySelector('.remove-date').addEventListener('click', function () {
            newDateField.remove();
        });
    });
</script>
@endsection
