@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">

<!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">

    <div class="row">
        <div class="col-md-6">
            <h4 class="py-3 mb-4">
              <span class="text-muted fw-light">
                <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
              </span>
              {{__('lang.admin_category_import_export')}}</h4>
        </div>
    </div>

    <!-- Category export scren -->
    <div class="card">
        <div class="card-header">
                <div class="row">
                    <div class="col-md-11 mt-2">
                        <h5 class="card-title display-inline-block">{{__('lang.admin_category_export')}}
                        </h5>
                    </div>

                    <div class="col-md-1 mt-2">
                        <i class="ti ti-alert-triangle ti-flashing cursor_pointer" data-bs-toggle="popover" data-bs-placement="left" data-bs-content=" Lorem ipsum may be used as a placeholder before the final copy is available." data-bs-original-title="{{__('lang.admin_export_instrucations')}}" aria-describedby="popover203296"></i>
                    </div>
                </div>


            <form method="POST" action="{{url('admin/export-categories')}}">
                    @csrf
                <div class="row">
                    <div class="col-sm-3 display-inline-block">
                         <label class="form-label" for="name">{{__('lang.admin_select_type')}}</label>
                        <select class="form-control export_select_tag" name="type">
                            <option value="all_data">{{__('lang.admin_all_data')}}</option>
                            <option value="date_wise">{{__('lang.admin_date_wise')}}</option>
                            <option value="id_wise">{{__('lang.admin_id_wise')}}</option>
                        </select>
                    </div>

                    <div class="col-sm-3 display-inline-block date_wise_input" style="display: none;">
                        <label class="form-label" for="name">{{__('lang.admin_from_date')}}</label>
                       <input type="date" name="from_date" class="form-control">
                    </div>

                    <div class="col-sm-3 display-inline-block date_wise_input" style="display: none;">
                        <label class="form-label" for="name">{{__('lang.admin_to_date')}}</label>
                       <input type="date" name="to_date" class="form-control">
                    </div>


                    <div class="col-sm-3 display-inline-block id_wise_input" style="display: none;">
                        <label class="form-label" for="name">{{__('lang.admin_from_id')}}</label>
                       <input type="number" name="from_id" class="form-control">
                    </div>

                    <div class="col-sm-3 display-inline-block id_wise_input" style="display: none;">
                        <label class="form-label" for="name">{{__('lang.admin_to_id')}}</label>
                       <input type="number" name="to_id" class="form-control">
                    </div>

                    <div class="col-sm-3 display-inline-block mt-4">
                        <button type="submit" class="btn btn-primary data-submit">{{__('lang.admin_export')}}</button>
                        <a type="reset" class="btn btn-outline-secondary"
                            href="{{url('admin/category-bulk')}}">{{__('lang.admin_reset')}}</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- End Category export scren -->


    <hr class="container-m-nx my-5">

    <!-- Category import scren -->
    <div class="card">
        <!-- for download the excel file -->
        <div class="card-header">
                <div class="row">
                    <div class="col-md-7">
                        <h5 class="card-title display-inline-block">{{__('lang.admin_download_spreadsheet_template')}}
                        </h5>
                    </div>
                    <div class="col-md-5">
                        <a href="{{ url('admin/download-category-sample-with-data') }}">
                        <button type="button" class="btn btn-info data-submit btn-sm ml-4">{{__('lang.admin_template_with_existing_data')}}</button></a>
                        <a href="{{ url('admin/download-category-sample-without-data') }}">
                        <button type="button" class="btn btn-info data-submit btn-sm">{{__('lang.admin_template_without_data')}}</button></a>
                        <i class="ti ti-alert-triangle ti-flashing cursor_pointer" data-bs-toggle="popover" data-bs-placement="left" data-bs-content=" Lorem ipsum may be used as a placeholder before the final copy is available." data-bs-original-title="{{__('lang.admin_import_instrucations')}}" aria-describedby="popover203296"></i>
                    </div>
                </div>
        </div>
        <!-- End for download the excel file -->

        <!-- for upload the excel file -->
        <div class="card-header">
            <form method="post" action="{{ url('admin/import-categories') }}" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <h5 class="card-title display-inline-block">{{__('lang.admin_import_category_file')}}</h5>

                    <div class="col-sm-8 display-inline-block">
                       <input type="file" name="import_file" class="form-control" accept=".xls, .xlsx, application/vnd.ms-excel, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" required>
                    </div>


                    <div class="col-sm-4 display-inline-block">
                        <button type="submit" class="btn btn-primary data-submit">{{__('lang.admin_import')}}</button>
                        <button type="submit" class="btn btn-warning data-submit">{{__('lang.admin_update')}}</button>
                        <a type="reset" class="btn btn-outline-secondary"
                            href="{{url('admin/category-bulk')}}">{{__('lang.admin_reset')}}
                        </a>
                    </div>
                </div>
            </form>
        </div>
        <!-- End for upload the excel file -->
    </div>
    <!-- End Category import scren -->

</div>
<!-- / Content -->

</div>
<!-- Content wrapper -->

@endsection
