@extends('admin.layouts.app')
@section('content')


        <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row">
                  
                  <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row">
                <!-- View sales -->
                <div class="col-xl-4 mb-4 col-lg-5 col-12">
                  <div class="card">
                    <div class="d-flex align-items-end row">
                      <div class="col-7">
                        <div class="card-body text-nowrap">
                            <h5 class="card-title mb-0">Month Booking 🎉</h5>
                          <!--<p class="mb-2">Best seller of the month</p>-->
                          <h4 class="text-primary mb-1">{{ $count }}</h4>
                           <a href="{{url('admin/bookings')}}" class="btn btn-primary">Booking</a>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- View sales -->

                <!-- Statistics -->
                <div class="col-xl-8 mb-4 col-lg-7 col-12">
                  <div class="card h-100">
                    <div class="card-header">
                      <div class="d-flex justify-content-between mb-3">
                        <h5 class="card-title mb-0">Statistics</h5>
                        <small class="text-muted">Updated 1 month ago</small>
                      </div>
                    </div>
                    <div class="card-body">
                      <div class="row gy-3">
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="badge rounded-pill bg-label-primary me-3 p-2">
                              <i class="ti ti-chart-pie-2 ti-sm"></i>
                            </div>
                            <div class="card-info">
                              <h5 class="mb-0">{{$bookingcount }}</h5>
                              <small>Sales</small>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="badge rounded-pill bg-label-info me-3 p-2">
                              <i class="ti ti-users ti-sm"></i>
                            </div>
                            <div class="card-info">
                              <h5 class="mb-0">{{ $customers }}</h5>
                              <small>Customers</small>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-3 col-6">
                          <div class="d-flex align-items-center">
                            <div class="badge rounded-pill bg-label-danger me-3 p-2">
                              <i class="ti ti-shopping-cart ti-sm"></i>
                            </div>
                            <div class="card-info">
                              <h5 class="mb-0">{{ $farmhouse }}</h5>
                              <small style="text-wrap: nowrap;">Farm House</small>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!--/ Statistics -->

                <div class="col-xl-4 col-12">
                  <div class="row">
                    <!-- Expenses -->
                    <div class="col-xl-6 mb-4 col-md-3 col-6">
                      <div class="card">
                        <div class="card-header pb-0">
                          <h5 class="card-title mb-0 text-center">{{ $farmhousemonth }}</h5>
                        </div>
                        <div class="card-body">
                          <!--<div id="expensesChart"></div>-->
                          <div class="mt-md-2 text-center mt-lg-3 mt-3">
                            <small class="text-muted mt-3">registered Farm House last month</small>
                          </div>
                        </div>
                      </div>
                    </div>
                    <!--/ Expenses -->

                    <!-- Profit last month -->
                     <div class="col-xl-6 mb-4 col-md-3 col-6">
                      <div class="card">
                        <div class="card-header pb-0">
                          <h5 class="card-title mb-0 text-center">{{ $farmhouseyear }}</h5>
                        </div>
                        <div class="card-body">
                          <!--<div id="expensesChart"></div>-->
                          <div class="mt-md-2 text-center mt-lg-3 mt-3">
                            <small class="text-muted mt-3">registered Farm House last Year</small>
                          </div>
                        </div>
                      </div>
                    </div>
                    <!--/ Profit last month -->

                    <!-- Generated Leads -->
                    <div class="col-xl-12 mb-4 col-md-6">
                      <div class="card">
                        <div class="card-body">
                          <div class="d-flex justify-content-between">
                            <div class="d-flex flex-column">
                              <div class="card-title mb-auto">
                                <h5 class="mb-1 text-nowrap">Most Booking Farm House</h5>
                                <small>{{$hotelWithMaxBookings->name }}</small>
                              </div>
                              <div class="chart-statistics">
                                <h3 class="card-title mb-1">{{ $hotelWithMaxBookings->bookings_count  }}</h3>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                     <div class="col-xl-12 mb-3 col-md-6">
                      <div class="card">
                        <div class="card-body">
                          <div class="d-flex justify-content-between">
                            <div class="d-flex flex-column">
                              <div class="card-title mb-auto">
                                <h5 class="mb-1 text-nowrap">least Booking Farm House</h5>
                                <small>{{$hotelWithMinBookings->name }}</small>
                              </div>
                              <div class="chart-statistics">
                                <h3 class="card-title mb-1">{{ $hotelWithMinBookings->bookings_count  }}</h3>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <!--/ Generated Leads -->
                  </div>
                </div>

                <!-- Revenue Report -->
                <div class="col-12 col-xl-8 mb-4">
                  <div class="card">
                    <div class="card-body p-0">
                      <div class="row row-bordered g-0">
                          <div class="card-header d-inline-block p-0 text-wrap position-absolute p-2">
                            <h5 class="m-0 card-title">Booking Report</h5>
                          </div>
                        <div class="col-md-12 position-relative py-3 mt-4">
                          
                          <div>
                              
                         
                            <canvas id="myChart" style="width:100%;max-width:600px"></canvas>
                            </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!--/ Revenue Report -->
                
                <!-- Popular Product -->
                <div class="col-md-6 col-xl-4 mb-4">
                  <div class="card h-100">
                    <div class="card-header d-flex justify-content-between">
                      <div class="card-title m-0 me-2">
                        <h5 class="m-0 me-2">Farm House List</h5>
                      </div>
                    </div>
                    <div class="card-body">
                      <ul class="p-0 m-0">
                         @foreach($farmhouselist as $farmhouse)
                        <li class="d-flex mb-4 pb-1">
                          <div class="me-3">
                            <img src="{{ url('uploads/hotel/front_image/'.$farmhouse->front_image)}}" alt="farm house" class="rounded" width="46" />
                          </div>
                          <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                            <div class="me-2">
                              <h6 class="mb-0">{{$farmhouse->name }}</h6>
                        
                            </div>
                            <div class="user-progress d-flex align-items-center gap-1">
                              <p class="mb-0 fw-medium">{{$farmhouse->price }}</p>
                            </div>
                          </div>
                        </li>
                        @endforeach
                      </ul>
                    </div>
                  </div>
                </div>
                <!--/ Popular Product -->
                       <!-- Popular Product -->
                <div class="col-md-10 col-xl-8 mb-4">
                  <div class="card h-100">
                    <div class="card-header d-flex justify-content-between">
                      <div class="card-title m-0 me-2">
                        <h5 class="m-0 me-2">Customers List</h5>
                      </div>
                    </div>
                    <div class="card-body w-100">
                      <ul class="p-0 m-0">
                         @foreach($userlist as $userlists)
                        <li class="d-flex mb-4 pb-1">
                             
                          <div class="me-3">
                             <h6 class="mb-0">{{$userlists->name }}</h6>
                          </div>
                          <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                            <div class="me-2">
                                 <p class="mb-0 fw-medium">{{$userlists->email }}</p>
                            </div>
                          </div>
                           <div class="me-3">
                             <h6 class="mb-0">{{$userlists->phone }}</h6>
                          </div>
                        </li>
                        @endforeach
                      </ul>
                    </div>
                  </div>
                </div>
                <!--/ Popular Product -->
              </div>
            </div>
            <!-- / Content -->

            <!-- Footer -->
            <!--<footer class="content-footer footer bg-footer-theme">-->
            <!--  <div class="container-xxl">-->
            <!--    <div-->
            <!--      class="footer-container d-flex align-items-center justify-content-between py-2 flex-md-row flex-column">-->
            <!--      <div>-->
            <!--        ©-->
            <!--        <script>-->
            <!--          document.write(new Date().getFullYear());-->
            <!--        </script>-->
            <!--        , made with ❤️ by-->
            <!--        <a href="https://pixinvent.com" target="_blank" class="footer-link text-primary fw-medium"-->
            <!--          >Pixinvent</a-->
            <!--        >-->
            <!--      </div>-->
            <!--      <div class="d-none d-lg-inline-block">-->
            <!--        <a href="https://themeforest.net/licenses/standard" class="footer-link me-4" target="_blank"-->
            <!--          >License</a-->
            <!--        >-->
            <!--        <a href="https://1.envato.market/pixinvent_portfolio" target="_blank" class="footer-link me-4"-->
            <!--          >More Themes</a-->
            <!--        >-->

            <!--        <a-->
            <!--          href="https://demos.pixinvent.com/vuexy-html-admin-template/documentation/"-->
            <!--          target="_blank"-->
            <!--          class="footer-link me-4"-->
            <!--          >Documentation</a-->
            <!--        >-->

            <!--        <a href="https://pixinvent.ticksy.com/" target="_blank" class="footer-link d-none d-sm-inline-block"-->
            <!--          >Support</a-->
            <!--        >-->
            <!--      </div>-->
            <!--    </div>-->
            <!--  </div>-->
            <!--</footer>-->
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
        <!-- Content wrapper -->
        
          @section("page-js-script")
          <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
          
          <script>
              const xValues = <?php echo json_encode($hotelNames); ?>;
              const yValues = <?php echo json_encode($bookingCounts); ?>;
              const minCount = <?php echo $minBookingCount; ?>;
              const maxCount = <?php echo $maxBookingCount; ?>;
              
              new Chart("myChart", {
                type: "line",
                data: {
                  labels: xValues,
                  datasets: [{
                    fill: false,
                    lineTension: 0,
                    backgroundColor: "rgba(0,0,255,1.0)",
                    borderColor: "rgba(0,0,255,0.1)",
                    data: yValues
                  }]
                },
                options: {
                  legend: {display: false},
                  scales: {
                    yAxes: [{
                      ticks: {
                        min: minCount,
                        max: maxCount
                      }
                    }]
                  }
                }
              });
            </script>
            

          
            @endsection

@endsection
       