@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">


    <form action="{{url('admin/update-offer')}}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="row">
            <div class="col-md-6">
                <h4 class="py-3 mb-4">
                  <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
                  </span><span class="text-muted fw-light">
                    <a href="{{url('admin/coupon')}}">{{__('lang.admin_offer_list')}}</a> /
                  </span>
                  {{__('lang.admin_edit_offer')}}</h4>
            </div>
            <div class="col-md-6">
                <div class="table-btn-css">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        <span class="ti-xs ti ti-plus me-1"></span>{{__('lang.admin_update')}}
                    </button>
                    <a type="reset" class="btn btn-outline-secondary" href="{{url('admin/coupon')}}">{{__('lang.admin_back')}}</a>
                </div>
            </div>
        </div>
        

        <!-- Coupon Edit -->
          <div class="row">

            <!-- First column-->
            <div class="col-12 col-lg-12">
              <!-- Coupon Information -->
              <div class="card mb-4">
                <div class="card-body row">
                  <!-- Title -->
                  <div class="mb-3 col-sm-12">
                    <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_title')}} <span class="required">*</span></label>
                    <input
                      type="text"
                      class="form-control"
                      value="{{$data->name}}"
                      id="ecommerce-product-name"
                      placeholder="{{__('lang.admin_name_placeholder')}}"
                      name="name"
                      aria-label="{{__('lang.admin_name')}}" required/>
                      <input type="hidden" name="id" value="{{$data->id}}">
                  </div>

                  <!--Banner Image -->
                    <div class="col-12">
                      <div class="mb-3">
                          <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_offer_banner_image')}} <span class="required">*</span></label>
                          <div class="avatar-upload">
                              <div class="avatar-edit">
                                      <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="image">
                                      <label for="imageUpload"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                  </div>
                                  <div class="avatar-preview">
                                      <div id="imagePreview" style='background-image: url("{{asset('/uploads/offer/'.$data->image)}}");'>
                                      </div>
                                  </div>
                          </div>
                      </div>
                    </div>

                </div>
              </div>
              <!-- /Coupon Information -->

            </div>
            <!-- /First column -->

          </div>
        <!-- end coupon add -->

    </form>
       

    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
