@extends('admin.layouts.app')

@section('content')
<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Main Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Page Title -->
        <h4 class="fw-bold py-3 mb-4">Add New offer</h4>
        
        <!-- Coupon Form -->
        <form action="{{ url('admin/save-vendor-offer') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <!-- Coupon Details Card -->
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Offer Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <!-- Hotel Selection -->
                                <div class="mb-3 col-12 col-lg-6">
                                    <label for="hotel_id" class="form-label">
                                        Hotel <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select select2" name="hotel_id"  id="price_id" required>
                                        <option value="">Select Hotel</option>
                                        @foreach($hotels as $hotel)
                                            <option value="{{ $hotel->id }}">{{ $hotel->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Offer Input -->
                                <div class="mb-3 col-12 col-lg-6">
                                    <label for="offer" class="form-label">
                                        Offer <span class="text-danger">*</span>
                                    </label>
                                    <input 
                                        type="text" 
                                        class="form-control" 
                                        id="offer" 
                                        name="offer" 
                                        placeholder="Enter offer" 
                                        required>
                                </div>
                            </div>
                            <!-- Submit Button -->
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="ti ti-plus me-1"></i> Submit
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Coupon Details Card -->
            </div>
        </form>
        <!-- End Coupon Form -->
    </div>
    <!-- End Main Content -->
</div>
<!-- End Content Wrapper -->
@endsection
