@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">


    <form action="{{url('admin/update-vendor-offer')}}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="id" value="{{ $offer->id }}" >
          <div class="row">
                <!-- Coupon Details Card -->
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Offer Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <!-- Hotel Selection -->
                                <div class="mb-3 col-12 col-lg-6">
                                    <label for="hotel_id" class="form-label">
                                        Hotel <span class="text-danger">*</span>
                                    </label>
                                   <select class="form-select select2" name="hotel_id" id="price_id" required>
                                        <option value="">Select Hotel</option>
                                        @foreach($hotels as $hotel)
                                            <option value="{{ $hotel->id }}" 
                                                {{ $hotel->id == $offer->hotel_id ? 'selected' : '' }}>
                                                {{ $hotel->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Offer Input -->
                                <div class="mb-3 col-12 col-lg-6">
                                    <label for="offer" class="form-label">
                                        Offer <span class="text-danger">*</span>
                                    </label>
                                 <input 
                                    type="text" 
                                    class="form-control" 
                                    id="offer" 
                                    name="offer" 
                                    placeholder="Enter offer" 
                                    value="{{ $offer->offer }}" 
                                    required>
                                </div>
                            </div>
                            <!-- Submit Button -->
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="ti ti-plus me-1"></i> Update
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Coupon Details Card -->
            </div>
    </form>
       

    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
