@extends('admin.layouts.app')
@section('content')

        <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Video Content</span></h4>

              <div class="row">
                <div class="col-md-12">
    
                  <div class="card mb-4">
                    <h5 class="card-header">Video</h5>
                    <!-- Account -->
                    <div class="card-body">
                         <form id="" method="POST" action="{{url('admin/save-video-content')}}" enctype="multipart/form-data">
                                @csrf
                                <div class="d-flex align-items-start align-items-sm-center gap-4">
                                      <video id="videoPlayer" width="320" height="240" controls>
                                        <source id="videoSource" src="{{ asset($videos->video_path) }}" type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video>

                                    <div class="button-wrapper">
                                        <label for="upload" class="btn btn-primary me-2 mb-3" tabindex="0">
                                            <span class="d-none d-sm-block">Video Upload</span>
                                            <i class="ti ti-upload d-block d-sm-none"></i>
                                            <input name="video"
                                                type="file"
                                                id="upload"
                                                class="account-file-input d-none"
                                                accept="video/mp4,video/x-m4v,video/*"
                                                onchange="previewVideo(this)">
                                        </label>
                                    </div>
                                </div>
                                
                                <div class="mt-2">
                                    <button type="submit" class="btn btn-primary me-2">{{__('lang.admin_save_changes')}}</button>
                                    <button type="button" class="btn btn-label-secondary">
                                        <a href="{{url('admin/dashboard')}}">{{__('lang.admin_cancel')}}</a>
                                    </button>
                                </div>
                            </form>
                            


                    </div>
                    <!-- /Account -->
                  </div>
    
                </div>
              </div>
            </div>
            <!-- / Content -->

          </div>
        <!-- Content wrapper -->
@endsection


<script>
    
        function previewVideo(input) {
            if (input.files && input.files[0]) {
                var file = input.files[0];
                var url = URL.createObjectURL(file);
                var video = document.getElementById('videoPlayer');
                var source = document.getElementById('videoSource');

                // Update video source and reload
                source.src = url;
                video.load();
                video.style.display = 'block'; // Make sure video is visible
            }
        }
</script>
   