<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\{ProtectedController,PaymentController};
use App\Http\Controllers\API\Auth\UserAPIController;
use App\Http\Controllers\API\ProfileAPIController;
use App\Http\Controllers\API\HotelAPIController;
use App\Http\Controllers\API\BookingAPIController;
use App\Http\Controllers\API\RatingAPIController;
use App\Http\Controllers\API\DataAPIController;
use App\Http\Controllers\API\CouponAPIController;
use App\Http\Controllers\API\SearchAPIController;
use App\Http\Controllers\API\Auth\VendorAPIController;
use App\Http\Controllers\API\Vendor\VendorProfileAPIController;
use App\Http\Controllers\API\Vendor\VendorHotelAPIController;
use App\Http\Controllers\API\Vendor\VendorCouponAPIController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
 Route::match(['get', 'head'], 'get-state', [HotelAPIController::class, 'getState']);
 
  Route::match(['get', 'head'], 'get-video-content', [HotelAPIController::class, 'getVideoContent']);
// Routes for Google Authentication
Route::match(['get', 'head'], 'sign-up-with-google', [UserAPIController::class, 'doRedirectToGoogle']);
    
Route::match(['get', 'head'], 'auth/google/callback', [UserAPIController::class, 'handleGoogleCallback']);

// Routes for API Key Authentication
Route::middleware('apiauth.api')->group(function () {
    // Protected route example
    Route::match(['get', 'head'], 'protected-endpoint', [ProtectedController::class, 'protectedMethod']);
    
    // User login Signup
    Route::post('login', [UserAPIController::class, 'doLogin']);
    Route::post('signup', [UserAPIController::class, 'doSignup']);
    Route::post('forgot-password', [UserAPIController::class, 'doForgotPassword']);
    
    // verify email
    Route::match(['get', 'head'], 'verify-email', [UserAPIController::class, 'doVerifyEmail']);
    
    Route::post('change-password', [UserAPIController::class, 'doChangePassword']);
    //become a host
     Route::post('becomeahost', [UserAPIController::class, 'becomeHost']);
    // latest hotel management
    Route::match(['get', 'head'], 'latest-hotels', [HotelAPIController::class, 'getLatestHotel']);
    
    Route::post('save-view-hotel', [HotelAPIController::class, 'saveViewHotel']);
    
    Route::post('recently-view-hotel', [HotelAPIController::class, 'recentlyViewHotel']);
    
    Route::post('vendor-view-hotel', [HotelAPIController::class, 'vendor_view_hotel']);
    
     Route::get('recently-booking', [HotelAPIController::class, 'recently_booking']);
    // Recently View
    Route::match(['get', 'head'], 'recently-view', [HotelAPIController::class, 'getRecentlyView']);
    
    // Ratings View
    Route::match(['get', 'head'], 'view-ratings', [RatingAPIController::class, 'getViewRating']);
    
    // location
    Route::match(['get', 'head'], 'location-list', [HotelAPIController::class, 'getLocationList']);
    // feature
    Route::match(['get', 'head'], 'feature-list', [HotelAPIController::class, 'getFeatureList']);
    
    // Rules
    Route::match(['get', 'head'], 'rules-list', [HotelAPIController::class, 'getRulesList']);
    
    // Aminity
    Route::match(['get', 'head'], 'aminity-list', [DataAPIController::class, 'getAminityList']);
    
    // Category
    Route::match(['get', 'head'], 'category-list', [DataAPIController::class, 'getCategoryList']);
    
    // Slider
    Route::match(['get', 'head'], 'slider-list', [DataAPIController::class, 'getSliderList']);
    
    // Offer
    Route::match(['get', 'head'], 'offer-list', [DataAPIController::class, 'getOfferList']);
    
    // feature
    Route::match(['get', 'head'], 'coupon-list', [BookingAPIController::class, 'getCouponList']);
    
    // Hotel List
    Route::match(['get', 'head'], 'hotel-list', [HotelAPIController::class, 'getHotelList']);
    // Hotel Details
    Route::match(['get', 'head'], 'hotel-details', [HotelAPIController::class, 'hotelDetails']);
    
    
    
    // Recommended List
    Route::match(['get', 'head'], 'recommended-list', [HotelAPIController::class, 'getRecommendedList']);
    
    // Explore Place
    Route::match(['get', 'head'], 'explore-place', [HotelAPIController::class, 'getExplorePlace']);
    
    // Search Data
    Route::match(['get', 'head'], 'search-data', [SearchAPIController::class, 'getSearchHotelList']);
    
    Route::match(['get', 'head'], 'search-data', [SearchAPIController::class, 'getSearchHotelList']);
       
     Route::match(['get', 'head'], 'all-hotel', [SearchAPIController::class, 'filterByName']); 
     
       Route::match(['get', 'head'], 'hotel-new-date-select', [SearchAPIController::class, 'hotelNewDateSelect']);
     
      Route::match(['post', 'head'], 'create-payment', [PaymentController::class, 'createPayment']); 
      Route::match(['post', 'head'], 'create-payment-app', [PaymentController::class, 'createPaymentapp']); 
      
        Route::match(['post', 'head'], 'payment-verify', [PaymentController::class, 'paymentVerify']); 
       
    
});

// Routes for Token Authentication
Route::middleware('apiTokenauth:api')->group(function () {
    // Protected route example
    Route::match(['get', 'head'], 'protected-authpoint', [ProtectedController::class, 'protectedAuthMethod']);
    
    // User profile edit and update
    Route::match(['get', 'head'], 'user-profile', [ProfileAPIController::class, 'userProfile']);
    Route::post('update-profile', [ProfileAPIController::class, 'doUpdateProfile']);
    
    // User save Booking
    Route::post('save-booking', [BookingAPIController::class, 'doSaveBooking']);
    
    // User Cancel Booking
    Route::post('cancel-booking', [BookingAPIController::class, 'doCancelBooking']);
    
    // User Save Ratings
    Route::post('save-ratings', [RatingAPIController::class, 'doSaveRating']);
    
    // User Apply Coupon
    Route::post('apply-coupon', [CouponAPIController::class, 'doApplyCoupon']);
    
    // trips list Upcoming/Complete
    Route::match(['get', 'head'], 'trips-list', [BookingAPIController::class, 'getTripsHotel']);
    
     Route::match(['get', 'head'], 'trips-all-list-data', [BookingAPIController::class, 'tripsAllListData']);
    
    // Bookings
    Route::match(['get', 'head'], 'bookings', [BookingAPIController::class, 'getBookingAllData']);
    
    // Bookings Details
    Route::match(['get', 'head'], 'booking-details', [BookingAPIController::class, 'getBookingDetailsData']);
    
    
    // Bookings Details for app
    Route::match(['get', 'head'], 'reason-list', [BookingAPIController::class, 'reasonList']);
});


// =======================Vendor Route Start here=======================
Route::group(['prefix' => 'vendor'], function () {
    
    Route::middleware('apiauth.api')->group(function () {
    Route::match(['get', 'head'], 'protected-endpoint', [ProtectedController::class, 'protectedMethod']);
    
    Route::post('login', [VendorAPIController::class, 'doLogin']);
    Route::post('signup', [VendorAPIController::class, 'doSignup']);
    
    Route::match(['get', 'head'], 'customer', [VendorCouponAPIController::class, 'customerListing']);
    
    });
    
    // Routes for Token Authentication
    Route::middleware('apiTokenVendorAuth:api')->group(function () {
            
    Route::match(['get', 'head'], 'protected-authpoint', [ProtectedController::class, 'protectedVendorAuthMethod']);
        
    Route::match(['get', 'head'], 'profile', [VendorProfileAPIController::class, 'vendorProfile']);
    
    Route::post('update-profile', [VendorProfileAPIController::class, 'doUpdateProfile']);
    
    Route::post('change-password', [VendorProfileAPIController::class, 'doChangePassword']);
    
    Route::post('save-hotel', [VendorHotelAPIController::class, 'doSaveHotel']);
    
     Route::post('venodor-offers', [VendorHotelAPIController::class, 'VenodorOffer']);
    
   Route::get('notifications', [VendorHotelAPIController::class, 'getNotifications']);
   
   Route::get('get-hotel-bookings', [VendorHotelAPIController::class, 'gethotelBookings']);
    
    Route::match(['get', 'head'], 'hotel-listing', [VendorHotelAPIController::class, 'vendorHotelListing']);
    
    Route::match(['get', 'head'], 'edit-hotel', [VendorHotelAPIController::class, 'EditHotel']);
    
    Route::match(['post', 'head'], 'agreement-from', [VendorHotelAPIController::class, 'agreementFrom']);
    
    
    Route::match(['get', 'head'], 'delete-hotel', [VendorHotelAPIController::class, 'deleteHotel']);
    
    Route::post('update-hotel', [VendorHotelAPIController::class, 'doUpdateHotel']);
    
    Route::post('save-coupon', [VendorCouponAPIController::class, 'doSaveCoupon']);
    
    Route::post('block-date', [VendorHotelAPIController::class, 'blockDate']);
    
    Route::match(['get', 'head'], 'view-coupons', [VendorCouponAPIController::class, 'vendorCouponListing']);
    
    Route::match(['get', 'head'], 'edit-coupons', [VendorCouponAPIController::class, 'vendorCouponEdit']);
    
    Route::post('update-coupon', [VendorCouponAPIController::class, 'doUpdateCoupon']);
    
    Route::match(['get', 'head'], 'hotels', [VendorCouponAPIController::class, 'hotelListing']);
    
    });
    
});
// =======================Vendor Route End here=======================