<?php

use Illuminate\Support\Facades\Route;

// clear cache
Route::get('/clear', function() {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    return "Cache is cleared";
}); 

// Artisan Commands
Route::get('/developer-cmd', function() {
    Artisan::call('make:migration create_ratings_table --create=ratings');
    Artisan::call('make:model Rating');
    Artisan::call('make:controller API/RatingAPIController --resource');
    // Artisan::call('make:seeder NotificationSeeder');
    return "created";
});

// migrate table
Route::get('/admin-run-migrations', function () {
    Artisan::call('migrate');
    return "Migrations executed successfully";
});
 
// create middleware
Route::get('/admin-create-middleware', function() {
    Artisan::call('make:middleware AuthenticateUserApi');
    return "Middleware created";
});

// View Route
Route::get('/admin-route-list', function() {
    Artisan::call('route:list');
    return "data retrived";
});


// for Authentication Failed
Route::get('authentication-failed', function () {
    $errors = [];
    array_push($errors, ['code' => 'auth-001', 'message' => 'Unauthenticated.']);
    return response()->json([
        'errors' => $errors,
    ], 401);
})->name('authentication-failed');
// for Authentication Failed
